/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.wicked;

import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class BerserkerGeas
extends GeasEffect {
    private float storedDamage;
    private boolean resetDamageNextTick;

    public BerserkerGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_REAPER.get());
    }

    public void incomingDamageEvent(LivingIncomingDamageEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        this.storedDamage = (this.storedDamage + 4.0f + event.getAmount()) * 0.8f;
    }

    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        event.setNewDamage(event.getNewDamage() * 2.0f);
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("damage_buildup", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("damage_release", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("more_damage", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        if (this.resetDamageNextTick) {
            this.storedDamage = 0.0f;
            this.resetDamageNextTick = false;
        } else if (entity.level().getGameTime() % 40L == 0L) {
            this.storedDamage *= 0.95f;
        }
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target.level().isClientSide) {
            return;
        }
        if (event.getSource().is(MalumDamageTypes.BERSERKER_SPIRIT_IMPACT)) {
            return;
        }
        if (this.storedDamage >= 4.0f) {
            int hits = Mth.ceil((float)(this.storedDamage / 4.0f));
            for (int i = 0; i < hits; ++i) {
                WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(0.0f, 2.0f, 10 + i * 2).setMagicDamageType(MalumDamageTypes.BERSERKER_SPIRIT_IMPACT).setImpactParticleEffect(MalumParticleEffectTypes.BERSERKER_IMPACT, new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT)).setSound((Holder<SoundEvent>)MalumSoundEvents.BERSERKER_WRATH, 0.7f, 1.3f, 1.0f));
            }
            this.resetDamageNextTick = true;
        }
    }
}

