/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item;

import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BlightedGunkItem
extends ItemNameBlockItem {
    public final Block wallPlacement;

    public BlightedGunkItem(Item.Properties pProperties) {
        this((Block)MalumBlocks.BLIGHTED_GROWTH.get(), (Block)MalumBlocks.CLINGING_BLIGHT.get(), pProperties);
    }

    public BlightedGunkItem(Block defaultPlacement, Block wallPlacement, Item.Properties pProperties) {
        super(defaultPlacement, pProperties);
        this.wallPlacement = wallPlacement;
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext pContext) {
        Player player = pContext.getPlayer();
        BlockState wallPlacementState = this.wallPlacement.getStateForPlacement(pContext);
        BlockState defaultState = this.getBlock().getStateForPlacement(pContext);
        BlockState placed = wallPlacementState;
        if (player != null && player.isShiftKeyDown() || placed == null) {
            placed = defaultState;
        }
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        return placed != null && this.canPlace(pContext, placed) && levelreader.isUnobstructed(placed, blockpos, CollisionContext.empty()) ? placed : null;
    }

    public void registerBlocks(Map<Block, Item> pBlockToItemMap, Item pItem) {
        super.registerBlocks(pBlockToItemMap, pItem);
        pBlockToItemMap.put(this.wallPlacement, pItem);
    }
}

