/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment;

import com.sammy.malum.common.item.augment.AugmentItem;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class WarpingEngineItem
extends AugmentItem {
    public WarpingEngineItem(Item.Properties pProperties) {
        super(pProperties, MalumSpiritTypes.ELDRITCH_SPIRIT, new ArtificeModifier(ArtificeAttributeType.CHAIN_FOCUSING_CHANCE, 0.1f), new ArtificeModifier(ArtificeAttributeType.TUNING_STRAIN, 0.05f), new ArtificeModifier(ArtificeAttributeType.FUEL_USAGE_RATE, 0.15f));
    }

    public static boolean skipForward(Level level, BlockPos pos, ArtificeAttributeData attributes) {
        boolean success;
        float chainFocusingChance = attributes.chainFocusingChance.getValue(attributes);
        RandomSource random = level.getRandom();
        boolean bl = success = chainFocusingChance > 0.0f && random.nextFloat() < chainFocusingChance;
        if (success) {
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.WARPING_ENGINE_REVERBERATES.get(), SoundSource.BLOCKS, 1.5f, 1.0f + random.nextFloat() * 0.25f);
        }
        attributes.chainProcessingBonus = success ? attributes.chainProcessingBonus + 0.2f : 0.0f;
        return success;
    }
}

