/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.augment.core;

import com.sammy.malum.common.item.augment.core.CoreAugmentItem;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeType;
import com.sammy.malum.core.systems.artifice.ArtificeModifier;
import com.sammy.malum.core.systems.artifice.TuningModifier;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;

public class ResonanceTuner
extends CoreAugmentItem {
    public ResonanceTuner(Item.Properties pProperties) {
        super(pProperties, List.of(MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT), true, new ArtificeModifier(ArtificeAttributeType.RESONANCE_TUNING, 1.0f));
    }

    public static void exchangeSpeed(ArtificeAttributeData data) {
        float instability;
        float goal;
        float speed;
        float conversion;
        float resonanceTuning = data.resonanceTuning.getValue(data);
        if (resonanceTuning > 0.0f && (conversion = Mth.clampedLerp((float)0.0f, (float)1.0f, (float)((speed = data.focusingSpeed.getValue(data)) / (goal = Math.min((instability = data.instability.getValue(data)) * resonanceTuning, speed) * 2.0f)))) > 0.0f) {
            float toll = Mth.clamp((float)(goal / speed), (float)0.0f, (float)1.0f) * 0.8f;
            data.focusingSpeed.applyModifier(new TuningModifier(TuningModifier.RESONANCE_TUNING, -toll));
            data.instability.applyModifier(new TuningModifier(TuningModifier.RESONANCE_TUNING, -conversion));
        }
    }
}

