/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.banner;

import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class SoulwovenBannerBlockItem
extends BlockItem {
    public SoulwovenBannerBlockItem(Item.Properties properties) {
        super((Block)MalumBlocks.SOULWOVEN_BANNER.get(), properties.component(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)SoulwovenBannerPatternDataComponent.DEFAULT));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        SoulwovenBannerPatternDataComponent pattern = (SoulwovenBannerPatternDataComponent)stack.get(MalumDataComponents.SOULWOVEN_BANNER_PATTERN);
        if (pattern != null && !pattern.equals(SoulwovenBannerPatternDataComponent.DEFAULT)) {
            tooltipComponents.add((Component)Component.translatable((String)pattern.translationKey()).withStyle(ChatFormatting.GRAY));
        }
    }

    public static float getBannerPattern(ItemStack stack) {
        SoulwovenBannerPatternDataComponent pattern = (SoulwovenBannerPatternDataComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_BANNER_PATTERN, (Object)SoulwovenBannerPatternDataComponent.DEFAULT);
        return SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS.contains(pattern) ? (float)SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS.indexOf(pattern) : 0.0f;
    }

    public static void addBannerVariantsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack source = ((Item)MalumItems.SOULWOVEN_BANNER.get()).getDefaultInstance();
        if (event.getParentEntries().contains((Object)source)) {
            ArrayList<SoulwovenBannerPatternDataComponent> patterns = new ArrayList<SoulwovenBannerPatternDataComponent>(SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS);
            patterns.remove(SoulwovenBannerPatternDataComponent.DEFAULT);
            patterns.remove(SoulwovenBannerPatternDataComponent.COLORFUL_WORLD);
            Collections.reverse(patterns);
            SoulwovenBannerBlockItem.tryAddBannerVariant(event, SoulwovenBannerPatternDataComponent.COLORFUL_WORLD, true);
            for (SoulwovenBannerPatternDataComponent pattern : patterns) {
                SoulwovenBannerBlockItem.tryAddBannerVariant(event, pattern, false);
            }
        }
    }

    public static void tryAddBannerVariant(BuildCreativeModeTabContentsEvent event, SoulwovenBannerPatternDataComponent pattern, boolean before) {
        ItemStack source = ((Item)MalumItems.SOULWOVEN_BANNER.get()).getDefaultInstance();
        ItemStack colorfulWorld = pattern.getDefaultStack();
        if (!event.getParentEntries().contains((Object)colorfulWorld)) {
            if (before) {
                event.insertBefore(source, colorfulWorld, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else {
                event.insertAfter(source, colorfulWorld, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

