/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TemporarilyDisabledItem
extends Item {
    public TemporarilyDisabledItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            Disabled disabled = (Disabled)pStack.get(MalumDataComponents.DISABLED);
            if (disabled != null) {
                long time = disabled.time();
                if (pLevel.getGameTime() >= time) {
                    TemporarilyDisabledItem.enable(player, pSlotId);
                    return;
                }
            }
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public static void disable(ServerPlayer player, int slot, Supplier<Item> disabledItemType) {
        Inventory inventory = player.getInventory();
        ItemStack disabled = disabledItemType.get().getDefaultInstance();
        disabled.set(MalumDataComponents.DISABLED, (Object)new Disabled(inventory.getItem(slot), player.level().getGameTime() + 300L));
        inventory.setItem(slot, disabled);
    }

    public static void enable(ServerPlayer player, int slot) {
        ItemStack original;
        Inventory inventory = player.getInventory();
        ItemStack disabledItem = inventory.getItem(slot);
        Disabled disabled = (Disabled)disabledItem.get(MalumDataComponents.DISABLED);
        if (disabled != null && !(original = disabled.item()).isEmpty()) {
            inventory.setItem(slot, original);
        }
    }

    public record Disabled(ItemStack item, long time) {
        public static Codec<Disabled> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(Disabled::item), (App)Codec.LONG.fieldOf("time").forGetter(Disabled::time)).apply((Applicative)instance, Disabled::new));
        public static StreamCodec<RegistryFriendlyByteBuf, Disabled> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, p -> p.item, (StreamCodec)ByteBufCodecs.VAR_LONG, p -> p.time, Disabled::new);
    }
}

