/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.helpers.RandomHelper;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class AbstractMalumCurioItem
extends Item
implements ICurioItem {
    public final MalumTrinketType type;

    public AbstractMalumCurioItem(Item.Properties properties, MalumTrinketType type) {
        super(properties);
        this.type = type;
    }

    public void addAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.addAttributeModifiers((Multimap<Holder<Attribute>, AttributeModifier>)map, slotContext, stack);
        return map;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        livingEntity.level().playSound(null, livingEntity.blockPosition(), this.type.sound.get(), SoundSource.PLAYERS, 1.0f, RandomHelper.randomBetween((RandomSource)livingEntity.getRandom(), (float)0.9f, (float)1.1f));
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void addAttributeModifier(Multimap<Holder<Attribute>, AttributeModifier> map, Holder<Attribute> attribute, AttributeModifier modifier) {
        map.put(attribute, (Object)modifier);
    }

    public static enum MalumTrinketType {
        CLOTH((Supplier<SoundEvent>)MalumSoundEvents.CLOTH_TRINKET_EQUIP),
        ORNATE((Supplier<SoundEvent>)MalumSoundEvents.ORNATE_TRINKET_EQUIP),
        GILDED((Supplier<SoundEvent>)MalumSoundEvents.GILDED_TRINKET_EQUIP),
        ALCHEMICAL((Supplier<SoundEvent>)MalumSoundEvents.ALCHEMICAL_TRINKET_EQUIP),
        ROTTEN((Supplier<SoundEvent>)MalumSoundEvents.ROTTEN_TRINKET_EQUIP),
        METALLIC((Supplier<SoundEvent>)MalumSoundEvents.METALLIC_TRINKET_EQUIP),
        VOID((Supplier<SoundEvent>)MalumSoundEvents.VOID_TRINKET_EQUIP),
        RUNE((Supplier<SoundEvent>)MalumSoundEvents.RUNE_EQUIP),
        TOTEMIC_RUNE((Supplier<SoundEvent>)MalumSoundEvents.TOTEMIC_RUNE_EQUIP),
        VOID_RUNE((Supplier<SoundEvent>)MalumSoundEvents.VOID_RUNE_EQUIP);

        final Supplier<SoundEvent> sound;

        private MalumTrinketType(Supplier<SoundEvent> sound) {
            this.sound = sound;
        }
    }
}

