/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.runes;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.registry.rite.RiteEffectHolder;
import com.sammy.malum.core.systems.rite.effect.SpiritRitePotionEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class TotemicRuneCurioItem
extends AbstractRuneCurioItem {
    protected final RiteEffectHolder<? extends SpiritRitePotionEffect<?>> effect;

    public TotemicRuneCurioItem(Item.Properties builder, RiteEffectHolder<? extends SpiritRitePotionEffect<?>> effect, SpiritHolder<SpiritArcanaType> spirit) {
        super(builder, spirit, AbstractMalumCurioItem.MalumTrinketType.TOTEMIC_RUNE);
        this.effect = effect;
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        Component effectName = ((MobEffect)((SpiritRitePotionEffect)this.effect.value()).getEffect().value()).getDisplayName();
        consumer.accept(ComponentHelper.positiveCurioEffect("totem_effect", effectName));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ServerLevel level;
        LivingEntity target = slotContext.entity();
        Level level2 = target.level();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameTime() % 5L == 0L) {
            ((SpiritRitePotionEffect)this.effect.value()).applyRuneEffect(level, target);
        }
        super.curioTick(slotContext, stack);
    }
}

