/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.runes.madness;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.curiosities.curios.runes.madness.MadnessRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import top.theillusivec4.curios.api.SlotContext;

public class RuneRadialEmpowermentItem
extends MadnessRuneCurioItem
implements ItemEventHandler.IEventResponder {
    private static final ResourceLocation MODIFIER = MalumMod.malumPath("radial_empowerment_rune");

    public RuneRadialEmpowermentItem(Item.Properties builder) {
        super(builder, MalumSpiritTypes.WICKED_SPIRIT);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("scythe_chain", new Object[0]));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity entity = slotContext.entity();
        AttributeInstance attribute = entity.getAttribute(Attributes.SWEEPING_DAMAGE_RATIO);
        if (attribute != null) {
            attribute.removeModifier(MODIFIER);
        }
    }

    public void outgoingDamageEvent(LivingIncomingDamageEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        DamageSource source = event.getSource();
        if (source.is(MalumTags.DamageTypeTags.IS_SCYTHE_MELEE) && !source.is(MalumDamageTypes.SCYTHE_SWEEP)) {
            AttributeInstance attribute = attacker.getAttribute(Attributes.SWEEPING_DAMAGE_RATIO);
            if (attribute == null) {
                return;
            }
            float amount = target.getHealth() < target.getMaxHealth() * 0.33f ? 0.4f : 0.2f;
            attribute.removeModifier(MODIFIER);
            attribute.addTransientModifier(new AttributeModifier(MODIFIER, (double)amount, AttributeModifier.Operation.ADD_VALUE));
        }
    }
}

