/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.prospector;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import team.lodestar.lodestone.helpers.CurioHelper;
import top.theillusivec4.curios.api.CuriosApi;

public class CurioProspectorBelt
extends MalumCurioItem {
    public CurioProspectorBelt(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.METALLIC);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer, Item.TooltipContext context) {
        Component fortune = Enchantment.getFullname((Holder)context.registries().holderOrThrow(Enchantments.FORTUNE), (int)3);
        consumer.accept(ComponentHelper.positiveCurioEffect("enchanted_explosions", fortune.copy().withStyle(ChatFormatting.BLUE)));
        consumer.accept(ComponentHelper.positiveCurioEffect("ore_prospecting", new Object[0]));
    }

    public static LootParams.Builder applyFortune(Entity source, LootParams.Builder builder) {
        if (source instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)source;
            Level level = living.level();
            HolderLookup.RegistryLookup registriesProvider = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            if (CurioProspectorBelt.hasProspectorBelt(living)) {
                int fortuneBonus = 3 + CuriosApi.getCuriosInventory((LivingEntity)living).map(h -> h.getFortuneLevel(null)).orElse(0);
                ItemStack diamondPickaxe = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                diamondPickaxe.enchant((Holder)registriesProvider.getOrThrow(Enchantments.FORTUNE), fortuneBonus);
                return builder.withParameter(LootContextParams.TOOL, (Object)diamondPickaxe);
            }
        }
        return builder;
    }

    public static boolean hasProspectorBelt(LivingEntity entity) {
        return CurioHelper.hasCurioEquipped((LivingEntity)entity, (Item)((Item)MalumItems.BELT_OF_THE_PROSPECTOR.get()));
    }
}

