/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.pouch;

import com.sammy.malum.common.data.component.pouch.MalumPouchContentsComponent;
import com.sammy.malum.common.data.component.pouch.RavenousPouchContentsComponent;
import com.sammy.malum.common.item.curiosities.pouch.MalumPouchItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import team.lodestar.lodestone.helpers.SoundHelper;

public class RavenousPouchItem
extends MalumPouchItem {
    public RavenousPouchItem(Item.Properties properties) {
        super(properties.component(MalumDataComponents.RAVENOUS_POUCH_CONTENTS, (Object)RavenousPouchContentsComponent.EMPTY));
    }

    public static float getFullnessDisplay(ItemStack stack) {
        RavenousPouchContentsComponent contents = (RavenousPouchContentsComponent)stack.getOrDefault(MalumDataComponents.RAVENOUS_POUCH_CONTENTS, (Object)RavenousPouchContentsComponent.EMPTY);
        return contents.weight().floatValue();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add(ComponentHelper.positivePouchEffect("ravenous_pouch_collection", new Object[0]));
        tooltipComponents.add(ComponentHelper.positivePouchEffect("ravenous_pouch_drop", new Object[0]));
    }

    @Override
    public MalumPouchContentsComponent getContents(ItemStack stack) {
        return (MalumPouchContentsComponent)stack.getOrDefault(MalumDataComponents.RAVENOUS_POUCH_CONTENTS, (Object)RavenousPouchContentsComponent.EMPTY);
    }

    @Override
    public MalumPouchContentsComponent emptyContents() {
        return RavenousPouchContentsComponent.EMPTY;
    }

    @Override
    public void setContents(ItemStack stack, MalumPouchContentsComponent contents) {
        stack.set(MalumDataComponents.RAVENOUS_POUCH_CONTENTS, (Object)((RavenousPouchContentsComponent)contents));
    }

    @Override
    protected boolean dropContents(ItemStack stack, MalumPouchContentsComponent contents, Player player) {
        if (!contents.isEmpty()) {
            if (player instanceof ServerPlayer) {
                MalumPouchContentsComponent.Mutable mutable = contents.mutable();
                mutable.clearItems();
                contents.getItems().forEach(item -> {
                    ItemStack droppedItem = item.copy();
                    if (!mutable.containsItem((ItemLike)item.getItem()) && droppedItem.getCount() > 1) {
                        ItemStack split = droppedItem.split(1);
                        mutable.addItem(split);
                    }
                    player.drop(droppedItem, true);
                });
                this.setContents(stack, mutable.immutable());
            }
            return true;
        }
        return false;
    }

    @Override
    public void playInsertSound(Entity entity) {
        if (!entity.level().isClientSide) {
            SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.RAVENOUS_POUCH_INSERT.get()), (float)0.8f, (float)(0.8f + entity.level().getRandom().nextFloat() * 0.4f));
        }
        entity.playSound((SoundEvent)MalumSoundEvents.RAVENOUS_POUCH_INSERT.get(), 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public static void trySwallowItem(ItemEntityPickupEvent.Pre event) {
        if (event.canPickup().isFalse()) {
            return;
        }
        ItemEntity itemEntity = event.getItemEntity();
        if (itemEntity.hasPickUpDelay()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack pickedUp = itemEntity.getItem();
        for (NonNullList playerInventory : player.getInventory().compartments) {
            for (ItemStack item : playerInventory) {
                if (!item.has(MalumDataComponents.RAVENOUS_POUCH_CONTENTS) || player.getCooldowns().isOnCooldown(item.getItem())) continue;
                RavenousPouchItem.trySwallowItem(player, item, pickedUp);
            }
        }
    }

    public static void trySwallowItem(Player player, ItemStack stack, ItemStack pickedUp) {
        RavenousPouchContentsComponent contents = (RavenousPouchContentsComponent)stack.get(MalumDataComponents.RAVENOUS_POUCH_CONTENTS);
        if (contents != null && contents.containsItem((ItemLike)pickedUp.getItem())) {
            Item item;
            RavenousPouchContentsComponent.Mutable mutable = new RavenousPouchContentsComponent.Mutable(contents);
            int i = mutable.tryInsert(pickedUp);
            if (i > 0 && (item = stack.getItem()) instanceof RavenousPouchItem) {
                RavenousPouchItem pouch = (RavenousPouchItem)item;
                pouch.playInsertSound((Entity)player);
            }
            stack.set(MalumDataComponents.RAVENOUS_POUCH_CONTENTS, (Object)mutable.immutable());
        }
    }
}

