/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.ether;

import com.sammy.malum.common.block.ether.EtherBlockEntity;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import team.lodestar.lodestone.handlers.screenparticle.ParticleEmitterHandler;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class EtherItem
extends BlockItem
implements ParticleEmitterHandler.ItemParticleSupplier {
    public static final DyedItemColor DEFAULT_FIRST_COLOR = new DyedItemColor(15712278, false);
    public static final DyedItemColor DEFAULT_SECOND_COLOR = new DyedItemColor(4607909, false);
    public final boolean isIridescent;

    public EtherItem(Block blockIn, Item.Properties properties, boolean isIridescent) {
        super(blockIn, properties);
        this.isIridescent = isIridescent;
    }

    public static boolean isIridescent(EtherBlockEntity blockEntity) {
        return EtherItem.isIridescent(blockEntity.getBlockState().getBlock().asItem().getDefaultInstance());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIridescent(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof EtherItem)) return false;
        EtherItem ether = (EtherItem)item;
        if (!ether.isIridescent) return false;
        return true;
    }

    public static int getSecondaryColor(ItemStack stack) {
        if (stack.has(MalumDataComponents.SECONDARY_DYED_COLOR)) {
            return ((DyedItemColor)stack.get(MalumDataComponents.SECONDARY_DYED_COLOR)).rgb();
        }
        return DEFAULT_SECOND_COLOR.rgb();
    }

    public static int getPrimaryColor(ItemStack stack) {
        if (stack.has(DataComponents.DYED_COLOR)) {
            return ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb();
        }
        return DEFAULT_FIRST_COLOR.rgb();
    }

    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        Color firstColor = new Color(EtherItem.getPrimaryColor(stack));
        Color secondColor = new Color(EtherItem.getSecondaryColor(stack));
        float alphaMultiplier = this.isIridescent ? 0.75f : 0.5f;
        int yOffset = this.isIridescent ? 3 : 4;
        int xOffset = this.isIridescent ? -1 : 0;
        float time = (float)level.getGameTime() + partialTick;
        SpinParticleDataBuilder spinDataBuilder = SpinParticleData.create((float)0.0f, (float)1.0f).setSpinOffset(0.025f * time % 6.28f).setEasing(Easing.EXPO_IN_OUT);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.STAR, (ScreenParticleHolder)target).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.08f * alphaMultiplier), (float)0.0f).setEasing(Easing.QUINTIC_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)((float)(1.5 + Math.sin(time * 0.1f) * 0.125)), (float)0.0f).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.25f).build()).setLifetime(7).setRandomOffset((double)0.05f).setSpinData((SpinParticleDataWrapper)spinDataBuilder.build()).spawnOnStack((double)xOffset, (double)yOffset).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)((float)((double)1.4f - Math.sin(time * 0.075f) * 0.125)), (float)0.0f).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)secondColor, (Color)firstColor).build()).setSpinData((SpinParticleDataWrapper)spinDataBuilder.setSpinOffset(0.785f - 0.01f * time % 6.28f).build()).spawnOnStack((double)xOffset, (double)yOffset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canApplySecondaryColor(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof EtherItem)) return false;
        EtherItem ether = (EtherItem)item;
        if (!ether.isIridescent) return false;
        return true;
    }

    public static ItemStack applyDyesToSecondaryColor(ItemStack stack, List<DyeItem> dyes) {
        if (!stack.is(ItemTags.DYEABLE)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = stack.copyWithCount(1);
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int i1 = 0;
        DyedItemColor dyeditemcolor = (DyedItemColor)itemstack.get(MalumDataComponents.SECONDARY_DYED_COLOR);
        if (dyeditemcolor != null) {
            int j1 = FastColor.ARGB32.red((int)dyeditemcolor.rgb());
            int k1 = FastColor.ARGB32.green((int)dyeditemcolor.rgb());
            int l1 = FastColor.ARGB32.blue((int)dyeditemcolor.rgb());
            l += Math.max(j1, Math.max(k1, l1));
            i += j1;
            j += k1;
            k += l1;
            ++i1;
        }
        for (DyeItem dyeitem : dyes) {
            int j3 = dyeitem.getDyeColor().getTextureDiffuseColor();
            int i2 = FastColor.ARGB32.red((int)j3);
            int j2 = FastColor.ARGB32.green((int)j3);
            int k2 = FastColor.ARGB32.blue((int)j3);
            l += Math.max(i2, Math.max(j2, k2));
            i += i2;
            j += j2;
            k += k2;
            ++i1;
        }
        int l2 = i / i1;
        int i3 = j / i1;
        int k3 = k / i1;
        float f = (float)l / (float)i1;
        float f1 = Math.max(l2, Math.max(i3, k3));
        l2 = (int)((float)l2 * f / f1);
        i3 = (int)((float)i3 * f / f1);
        k3 = (int)((float)k3 * f / f1);
        int l3 = FastColor.ARGB32.color((int)0, (int)l2, (int)i3, (int)k3);
        boolean flag = dyeditemcolor == null || dyeditemcolor.showInTooltip();
        itemstack.set(MalumDataComponents.SECONDARY_DYED_COLOR, (Object)new DyedItemColor(l3, flag));
        return itemstack;
    }
}

