/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.food;

import com.sammy.malum.common.entity.thrown.ThrownConcentratedGluttony;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SplashOfGluttonyItem
extends Item {
    public SplashOfGluttonyItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide) {
            ThrownConcentratedGluttony thrownGluttony = new ThrownConcentratedGluttony(pLevel, (LivingEntity)pPlayer);
            thrownGluttony.setItem(itemstack);
            thrownGluttony.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), -20.0f, 0.5f, 1.0f);
            pLevel.addFreshEntity((Entity)thrownGluttony);
        }
        pPlayer.playSound(SoundEvents.SPLASH_POTION_THROW, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!pPlayer.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
    }
}

