/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.sound;

import com.sammy.malum.MalumMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

public class QuartzClusterSoundType
extends ExtendedSoundType {
    public QuartzClusterSoundType(float volumeIn, float pitchIn, Supplier<SoundEvent> breakSoundIn, Supplier<SoundEvent> stepSoundIn, Supplier<SoundEvent> placeSoundIn, Supplier<SoundEvent> hitSoundIn, Supplier<SoundEvent> fallSoundIn) {
        super(volumeIn, pitchIn, breakSoundIn, stepSoundIn, placeSoundIn, hitSoundIn, fallSoundIn);
    }

    public void onPlayBreakSound(Level level, BlockPos pos) {
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.AMETHYST_CLUSTER_BREAK, SoundSource.BLOCKS, (this.getVolume() + 2.0f) / 4.0f, this.getPitch() * 1.6f, false);
    }

    public void onPlayStepSound(Level level, BlockPos pos, BlockState state, SoundSource category) {
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_CLUSTER_STEP, category, this.getVolume() * 0.65f, this.getPitch() * 1.3f);
    }

    public void onPlayPlaceSound(Level level, BlockPos pos, Player player) {
        level.playSound(player, pos, SoundEvents.AMETHYST_CLUSTER_PLACE, SoundSource.BLOCKS, (this.getVolume() + 2.0f) / 4.0f, this.getPitch() * 1.5f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayHitSound(BlockPos pos) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(SoundEvents.AMETHYST_CLUSTER_HIT, SoundSource.BLOCKS, (this.getVolume() + 2.0f) / 16.0f, this.getPitch() * 1.65f, MalumMod.RANDOM, pos));
    }
}

