/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.infernal;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FurnaceAccelerationRiteEffect
extends SpiritRiteBlockEffect {
    public FurnaceAccelerationRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
            this.createEffect(level, pos, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT);
            int progress = Mth.floor((float)(20.0f * impact));
            this.quickenFurnace(level, furnace, progress, progress);
        }
    }

    public void quickenFurnace(ServerLevel level, AbstractFurnaceBlockEntity furnace, int removedLitTime, int addedCookingProgress) {
        int excess;
        if (!furnace.isLit()) {
            return;
        }
        int maxCookingTime = furnace.cookingTotalTime - 1;
        int excessLitTime = 0;
        int excessCookingProgress = 0;
        furnace.litTime -= removedLitTime;
        furnace.cookingProgress += addedCookingProgress;
        if (furnace.litTime < 1) {
            excess = Math.abs(furnace.litTime);
            furnace.litTime = 1;
            excessLitTime = excess;
        }
        if (furnace.cookingProgress > maxCookingTime) {
            excess = furnace.cookingProgress - maxCookingTime;
            furnace.cookingProgress = maxCookingTime;
            excessCookingProgress = excess;
        }
        if (excessLitTime > 0 || excessCookingProgress > 0) {
            AbstractFurnaceBlockEntity.serverTick((Level)level, (BlockPos)furnace.getBlockPos(), (BlockState)furnace.getBlockState(), (AbstractFurnaceBlockEntity)furnace);
            this.quickenFurnace(level, furnace, excessLitTime, excessCookingProgress);
        }
    }
}

