/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.wicked;

import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.DamageTypeHelper;

public class AnimalCullingEffect
extends SpiritRiteEntityEffect<Animal> {
    public AnimalCullingEffect() {
        super(List.of(SpiritRiteEffectTag.GREATER_RITE));
    }

    @Override
    public Class<Animal> getTargetClass() {
        return Animal.class;
    }

    @Override
    public void applyEffect(ServerLevel level, Animal target) {
        DamageSource damageSource = DamageTypeHelper.create((Level)level, MalumDamageTypes.VOODOO_PLAYERLESS);
        target.hurt(damageSource, target.getMaxHealth() * 2.0f);
        this.createEffect(level, target, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT);
    }

    @Override
    public List<Animal> findNearbyTargets(ServerLevel level, BlockPos source) {
        List<Animal> targets = super.findNearbyTargets(level, source);
        HashSet<List<Animal>> sorted = new HashSet<List<Animal>>(targets.stream().collect(Collectors.groupingBy(Object::getClass)).values());
        for (List<Animal> group : sorted) {
            if (group.size() >= 20) continue;
            targets.removeAll(group);
        }
        return targets;
    }

    @Override
    public boolean canApplyEffect(ServerLevel level, Animal target) {
        DamageSource damageSource = DamageTypeHelper.create((Level)level, MalumDamageTypes.VOODOO_PLAYERLESS);
        if (target.isInvulnerableTo(damageSource)) {
            return false;
        }
        if (target.isInLove()) {
            return false;
        }
        return target.getAge() >= 0;
    }
}

