/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.tree;

import com.sammy.malum.common.block.blight.CreepingBlightBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.blight.BlightFeature;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeFeature;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.worldgen.LodestoneWorldgenBuilder;
import team.lodestar.lodestone.systems.worldgen.LodestoneWorldgenBuilderEntry;
import team.lodestar.lodestone.systems.worldgen.LodestoneWorldgenBuilderLayer;
import team.lodestar.lodestone.systems.worldgen.PlacementCondition;

public class SoulwoodTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public SoulwoodTreeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    private static BlockState makeClingingBlight(CreepingBlightBlock.BlightType blightType, Direction direction) {
        return (BlockState)((BlockState)((Block)MalumBlocks.CLINGING_BLIGHT.get()).defaultBlockState().setValue(CreepingBlightBlock.BLIGHT_TYPE, (Comparable)((Object)blightType))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
    }

    private int getSapBlockCount(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)5, (int)7);
    }

    private int getSpikeCount(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)4, (int)6);
    }

    private int getTrunkHeight(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)10, (int)15);
    }

    private int getTwistCooldown(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)3, (int)5);
    }

    private int getTrunkTwistAmount(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)2, (int)6);
    }

    private int getSideTrunkHeight(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)1, (int)3);
    }

    private int getDownwardsBranchOffset(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)2, (int)4);
    }

    private int getBranchLength(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)3, (int)5);
    }

    private int getBranchTwistAmount(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)0, (int)2);
    }

    private int getBranchHeight(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)5, (int)6);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Direction direction;
        int i;
        BlockPos pos;
        WorldGenLevel level = context.level();
        if (level.isEmptyBlock((pos = context.origin()).below()) || !((Block)MalumBlocks.SOULWOOD_SAPLING.get()).defaultBlockState().canSurvive((LevelReader)level, pos)) {
            return false;
        }
        RandomSource rand = context.random();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        Block soulwoodLog = (Block)MalumBlocks.SOULWOOD_LOG.get();
        Block blightedSoulwoodLog = (Block)MalumBlocks.BLIGHTED_SOULWOOD.get();
        LodestoneWorldgenBuilder builder = LodestoneWorldgenBuilder.create();
        LodestoneWorldgenBuilderLayer treeLayer = builder.createLayer();
        LodestoneWorldgenBuilderLayer blightLayer = builder.createLayer();
        LodestoneWorldgenBuilderLayer leavesLayer = builder.createLayer();
        LodestoneWorldgenBuilder rootsBuilder = LodestoneWorldgenBuilder.create();
        LodestoneWorldgenBuilderLayer rootsLayer = rootsBuilder.createLayer();
        int trunkHeight = this.getTrunkHeight(rand);
        int twistCooldown = this.getTwistCooldown(rand);
        int remainingTwists = this.getTrunkTwistAmount(rand);
        int twistCutoffPoint = trunkHeight - 5;
        int twistDirectionIndex = rand.nextInt(4);
        for (int i2 = 0; i2 <= trunkHeight; ++i2) {
            if (i2 < twistCutoffPoint && twistCooldown == 0 && remainingTwists != 0) {
                Direction twistDirection = Direction.from2DDataValue((int)(twistDirectionIndex % 4));
                if (rand.nextFloat() < 0.75f) {
                    ++twistDirectionIndex;
                }
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                treeLayer.add((BlockPos)mutable, soulwoodLog);
                mutable.move(twistDirection);
                twistCooldown = this.getTwistCooldown(rand);
                --remainingTwists;
            }
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                return false;
            }
            treeLayer.add((BlockPos)mutable, i2 == 0 ? blightedSoulwoodLog : soulwoodLog);
            mutable.move(Direction.UP);
            --twistCooldown;
        }
        BlockPos trunkTop = mutable.immutable();
        for (i = 0; i < 4; ++i) {
            direction = Direction.from2DDataValue((int)i);
            BlockPos sidePos = pos.relative(direction);
            int sideTrunkHeight = this.getSideTrunkHeight(rand);
            mutable.set((Vec3i)sidePos);
            for (int j = 0; j < sideTrunkHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                treeLayer.add((BlockPos)mutable, soulwoodLog);
                mutable.move(Direction.UP);
            }
            BlockPos lowestLog = this.addDownwardsTrunkConnections(level, sidePos, p -> treeLayer.add(p, soulwoodLog));
            treeLayer.add(lowestLog, blightedSoulwoodLog);
            BlockPos clingingBlightPos = lowestLog.relative(direction);
            if (RunewoodTreeFeature.canPlace(level, clingingBlightPos)) {
                rootsLayer.add(clingingBlightPos, SoulwoodTreeFeature.makeClingingBlight(CreepingBlightBlock.BlightType.CLINGING_BLIGHT, direction.getOpposite())).addPlacementCondition(PlacementCondition.CAN_SURVIVE);
            }
            block3: for (int j = 0; j < 4; ++j) {
                int offset = rand.nextInt(2, 4);
                int sideOffset = rand.nextInt(-4, 4);
                BlockPos rootPos = lowestLog.relative(direction, offset).relative(direction.getClockWise(), sideOffset);
                Direction rootsDirection = rand.nextFloat() < 0.4f ? Direction.from2DDataValue((int)rand.nextInt(4)) : direction;
                BlockState roots = SoulwoodTreeFeature.makeClingingBlight(CreepingBlightBlock.BlightType.SOULWOOD_ROOTS, rootsDirection);
                mutable.set((Vec3i)rootPos);
                for (int k = 0; k < 4; ++k) {
                    if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                        if (k == 2) {
                            mutable.set((Vec3i)rootPos);
                        }
                    } else {
                        rootsLayer.add((BlockPos)mutable, roots).addPlacementCondition(PlacementCondition.CAN_SURVIVE);
                        continue block3;
                    }
                    mutable.move(k >= 2 ? Direction.UP : Direction.DOWN);
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            int j;
            direction = Direction.from2DDataValue((int)i);
            int downwardsBranchOffset = this.getDownwardsBranchOffset(rand);
            int branchLength = this.getBranchLength(rand);
            int branchHeight = this.getBranchHeight(rand);
            remainingTwists = this.getBranchTwistAmount(rand);
            twistCooldown = 1;
            mutable.set((Vec3i)trunkTop);
            mutable.move(Direction.DOWN, downwardsBranchOffset);
            for (j = 1; j < branchLength; ++j) {
                mutable.move(direction);
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                Direction.Axis axis = direction.getAxis();
                if (twistCooldown <= 0) {
                    treeLayer.add((BlockPos)mutable, (BlockState)soulwoodLog.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
                    mutable.move(Direction.UP);
                    twistCooldown = this.getTwistCooldown(rand);
                    --remainingTwists;
                }
                Direction opposite = direction.getOpposite();
                if (j == 1) {
                    blightLayer.add(mutable.below(), SoulwoodTreeFeature.makeClingingBlight(CreepingBlightBlock.BlightType.HANGING_BLIGHT, opposite));
                }
                treeLayer.add((BlockPos)mutable, (BlockState)soulwoodLog.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
                if (remainingTwists <= 0) continue;
                --twistCooldown;
            }
            for (j = 0; j < branchHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                treeLayer.add((BlockPos)mutable, soulwoodLog);
                mutable.move(Direction.UP);
            }
            SoulwoodTreeFeature.makeLeafBlob(leavesLayer, rand, (BlockPos)mutable.move(Direction.DOWN, branchHeight - 1));
        }
        for (LodestoneWorldgenBuilderEntry entry : SoulwoodTreeFeature.getRandomEntries(treeLayer.getOrderedEntries(), this.getSapBlockCount(rand), rand)) {
            entry.changeState(s -> {
                if (s.getBlock().equals(MalumBlocks.SOULWOOD_LOG.get())) {
                    return (BlockState)((Block)MalumBlocks.EXPOSED_SOULWOOD_LOG.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)s.getValue((Property)RotatedPillarBlock.AXIS)));
                }
                return s;
            });
        }
        for (LodestoneWorldgenBuilderEntry entry : SoulwoodTreeFeature.getRandomEntries(treeLayer.getOrderedEntries(), this.getSpikeCount(rand), rand)) {
            if (entry.position().getY() <= pos.getY() + 3) continue;
            entry.addAdditionalPlacement((l, e) -> {
                Direction direction = Direction.from2DDataValue((int)l.getRandom().nextInt(4));
                BlockPos offsetPos = e.position().relative(direction);
                e.place(l, offsetPos, SoulwoodTreeFeature.makeClingingBlight(CreepingBlightBlock.BlightType.SOULWOOD_SPIKE, direction.getOpposite()));
            });
        }
        LodestoneWorldgenBuilder blight = BlightFeature.generateBlight(level, pos, true, 10);
        builder.merge(blight);
        builder.place(level);
        rootsBuilder.place(level);
        WorldgenHelper.updateLeaves((LevelAccessor)level, treeLayer.getAffectedArea());
        return true;
    }

    private static <T> ArrayList<T> getRandomEntries(Collection<T> collection, int amount, RandomSource rand) {
        return new ArrayList<T>(WorldgenHelper.shuffle(collection, rand).subList(0, Math.min(amount, collection.size())));
    }

    public BlockPos addDownwardsTrunkConnections(WorldGenLevel level, BlockPos pos, Consumer<BlockPos> consumer) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        while (true) {
            mutable.move(Direction.DOWN);
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                return mutable.above();
            }
            consumer.accept(mutable.immutable());
        }
    }

    public static void makeLeafBlob(LodestoneWorldgenBuilderLayer layer, RandomSource rand, BlockPos pos) {
        int color;
        int size;
        int i;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        int[] leafSizes = new int[]{1, 2, 3, 3, 3, 2, 1};
        int[] leafColors = new int[]{4, 3, 2, 1, 2, 3, 4};
        for (i = 0; i < 7; ++i) {
            size = leafSizes[i];
            color = leafColors[i];
            SoulwoodTreeFeature.makeLeafSlice(layer, rand, (BlockPos)mutable, size, color);
            mutable.move(Direction.UP);
        }
        mutable = pos.mutable();
        for (i = 0; i < 3; ++i) {
            size = leafSizes[i];
            color = leafColors[i];
            SoulwoodTreeFeature.makeHangingLeaves(layer, rand, (BlockPos)mutable, size, color);
            mutable.move(Direction.UP);
        }
    }

    public static void makeLeafSlice(LodestoneWorldgenBuilderLayer leaves, RandomSource rand, BlockPos pos, int leavesSize, int leavesColor) {
        int offsetColor = leavesColor;
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                if (rand.nextFloat() < 0.05f) {
                    offsetColor = (offsetColor + 1) % 4;
                }
                BlockPos leavesPos = pos.offset(x, 0, z);
                leaves.add(leavesPos, (BlockState)((Block)MalumBlocks.SOULWOOD_LEAVES.get()).defaultBlockState().setValue((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(offsetColor)));
            }
        }
    }

    public static void makeHangingLeaves(LodestoneWorldgenBuilderLayer leaves, RandomSource rand, BlockPos pos, int leavesSize, int leavesColor) {
        int offsetColor = leavesColor;
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                float colorRate = RandomHelper.randomBetween((RandomSource)rand, (float)0.1f, (float)0.3f) + (float)leavesSize * 0.1f;
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                if (rand.nextFloat() < 0.05f) {
                    offsetColor = (offsetColor + 1) % 4;
                }
                BlockPos leavesPos = pos.offset(x, 0, z);
                if (x == 0 && z == 0) continue;
                int startOffset = Math.max(RandomHelper.randomBetween((RandomSource)rand, (int)0, (int)(leavesSize - 2)), 0);
                int size = 2 + RandomHelper.randomBetween((RandomSource)rand, (int)0, (int)leavesSize) - startOffset;
                BlockPos.MutableBlockPos mutable = leavesPos.mutable().move(Direction.UP, startOffset);
                for (int i = 0; i <= size; ++i) {
                    boolean hanging;
                    mutable.move(Direction.DOWN);
                    int color = offsetColor + Mth.floor((float)((float)i * colorRate));
                    boolean bl = hanging = i == size;
                    if (hanging && leaves.containsKey((BlockPos)mutable)) continue;
                    leaves.add((BlockPos)mutable, SoulwoodTreeFeature.createLeaves(hanging, color)).addPlacementCondition((l, e) -> l.getBlockState(e.position().above()).is((Block)MalumBlocks.SOULWOOD_LEAVES.get()));
                }
            }
        }
    }

    public static BlockState createLeaves(boolean hanging, int color) {
        Block leaves = hanging ? (Block)MalumBlocks.HANGING_SOULWOOD_LEAVES.get() : (Block)MalumBlocks.SOULWOOD_LEAVES.get();
        return (BlockState)leaves.defaultBlockState().setValue((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(Mth.clamp((int)color, (int)0, (int)4)));
    }
}

