/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.well;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.worldgen.well.WeepingWellStructurePiece;
import com.sammy.malum.registry.common.worldgen.MalumStructures;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WeepingWellStructure
extends Structure {
    public static final MapCodec<WeepingWellStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WeepingWellStructure.settingsCodec((RecordCodecBuilder.Instance)builder)).apply((Applicative)builder, WeepingWellStructure::new));

    public WeepingWellStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int blockZ;
        int baseHeight;
        int blockY;
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom random = context.random();
        RandomState randomState = context.randomState();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        if (random.nextFloat() < 0.4f) {
            return Optional.empty();
        }
        int blockX = chunkPos.getBlockX(random.nextInt(16));
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos(blockX, blockY = Mth.clamp((int)((baseHeight = chunkGenerator.getBaseHeight(blockX, blockZ = chunkPos.getBlockZ(random.nextInt(16)), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState)) - random.nextIntBetweenInclusive(64, 128)), (int)0, (int)32), blockZ);
        int y = this.extraChecks(context, (BlockPos)position);
        if (y == -1) {
            return Optional.empty();
        }
        position.setY(y);
        return Optional.of(new Structure.GenerationStub((BlockPos)position, b -> this.place(context, (StructurePiecesBuilder)b, levelHeightAccessor, position.immutable())));
    }

    public void place(Structure.GenerationContext context, StructurePiecesBuilder piecesBuilder, LevelHeightAccessor levelHeightAccessor, BlockPos pos) {
        ChunkPos chunkPos = context.chunkPos();
        int x = SectionPos.sectionToBlockCoord((int)chunkPos.x);
        int z = SectionPos.sectionToBlockCoord((int)chunkPos.z);
        BlockPos startPos = new BlockPos(x, pos.getY(), z);
        BoundingBox boundingBox = new BoundingBox(startPos.getX(), levelHeightAccessor.getMinBuildHeight(), startPos.getZ(), startPos.getX() + 15, levelHeightAccessor.getMaxBuildHeight(), startPos.getZ() + 15);
        piecesBuilder.addPiece((StructurePiece)new WeepingWellStructurePiece(pos, boundingBox));
    }

    private int extraChecks(Structure.GenerationContext context, BlockPos pos) {
        BlockState blockState;
        NoiseColumn baseColumn = context.chunkGenerator().getBaseColumn(pos.getX(), pos.getZ(), context.heightAccessor(), context.randomState());
        int surfaceLevel = pos.getY();
        while (true) {
            boolean isSolidFloor;
            if (context.heightAccessor().isOutsideBuildHeight(surfaceLevel)) {
                return -1;
            }
            BlockState blockState2 = baseColumn.getBlock(surfaceLevel);
            BlockState floor = baseColumn.getBlock(surfaceLevel - 1);
            boolean isEmptyBlock = blockState2.isAir() && blockState2.getFluidState().isEmpty();
            boolean bl = isSolidFloor = !floor.isAir() && !floor.canBeReplaced();
            if (isEmptyBlock && isSolidFloor) break;
            --surfaceLevel;
        }
        int emptySpace = 0;
        for (int i = 0; i < 20 && (blockState = baseColumn.getBlock(surfaceLevel + i)).isAir() && blockState.getFluidState().isEmpty(); ++i) {
            ++emptySpace;
        }
        if (emptySpace < 8) {
            return -1;
        }
        return surfaceLevel;
    }

    public StructureType<?> type() {
        return (StructureType)MalumStructures.StructureTypes.WEEPING_WELL.get();
    }
}

