/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compat.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.compat.jei.JEIHandler;
import com.sammy.malum.compat.jei.JEIHelper;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritInfusionRecipeCategory
implements IRecipeCategory<SpiritInfusionRecipe> {
    public static final ResourceLocation UID = MalumMod.malumPath("spirit_infusion");
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritInfusionRecipeCategory(IGuiHelper guiHelper) {
        this.overlay = guiHelper.createDrawable(MalumMod.malumPath("textures/gui/spirit_infusion_jei.png"), 0, 0, 142, 185);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MalumItems.SPIRIT_ALTAR.get()));
    }

    public void draw(SpiritInfusionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
        int spiritOffset = recipe.spirits.size() > 5 ? (recipe.spirits.size() - 5) * 10 : 0;
        CodexItemHelper.renderItemFrames(guiGraphics, recipe.spirits.size(), 20, 49 + spiritOffset, true);
        if (!recipe.extraInputs.isEmpty()) {
            int itemOffset = recipe.extraInputs.size() > 5 ? (recipe.extraInputs.size() - 5) * 10 : 0;
            CodexItemHelper.renderItemFrames(guiGraphics, recipe.extraInputs.size(), 104, 49 + itemOffset, true);
        }
    }

    public RecipeType<SpiritInfusionRecipe> getRecipeType() {
        return JEIHandler.SPIRIT_INFUSION;
    }

    public Component getTitle() {
        return Component.translatable((String)("malum.jei." + UID.getPath()));
    }

    public int getHeight() {
        return this.overlay.getHeight();
    }

    public int getWidth() {
        return this.overlay.getWidth();
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritInfusionRecipe recipe, IFocusGroup focuses) {
        int spiritOffset = recipe.spirits.size() > 5 ? (recipe.spirits.size() - 5) * 10 : 0;
        int itemOffset = recipe.extraInputs.size() > 5 ? (recipe.extraInputs.size() - 5) * 10 : 0;
        JEIHelper.addCustomIngredientToJei(builder, RecipeIngredientRole.INPUT, 20, 49 + spiritOffset, true, recipe.spirits);
        JEIHelper.addSizedIngredientsToJei(builder, RecipeIngredientRole.INPUT, 104, 49 + itemOffset, true, recipe.extraInputs);
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 57).addItemStacks(Arrays.stream(recipe.input.getItems()).toList());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 124).addItemStack(recipe.result);
    }
}

