/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compat.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.recipe.VoidFavorRecipe;
import com.sammy.malum.compat.jei.JEIHandler;
import com.sammy.malum.registry.common.item.MalumItems;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WeepingWellRecipeCategory
implements IRecipeCategory<VoidFavorRecipe> {
    public static final ResourceLocation UID = MalumMod.malumPath("weeping_well");
    private final IDrawable overlay;
    private final IDrawable icon;

    public WeepingWellRecipeCategory(IGuiHelper guiHelper) {
        this.overlay = guiHelper.createDrawable(MalumMod.malumPath("textures/gui/weeping_well_jei.png"), 0, 0, 142, 185);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MalumItems.VOID_DEPOT.get()));
    }

    public void draw(VoidFavorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
    }

    public RecipeType<VoidFavorRecipe> getRecipeType() {
        return JEIHandler.WEEPING_WELL;
    }

    public Component getTitle() {
        return Component.translatable((String)("malum.jei." + UID.getPath()));
    }

    public int getHeight() {
        return this.overlay.getHeight();
    }

    public int getWidth() {
        return this.overlay.getWidth();
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VoidFavorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 57).addIngredients(recipe.input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 124).addItemStack(recipe.result);
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(new ItemStack((ItemLike)MalumItems.VOID_DEPOT.get()));
    }
}

