/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.data.attachment.soul_data.LivingSoulData;
import com.sammy.malum.common.data.attachment.soul_data.ProjectileSoulData;
import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.compat.tetra.TetraCompat;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumTags;
import java.util.function.Predicate;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class SoulDataHandler {
    public static void markAsSpawnerSpawned(MobSpawnEvent.PositionCheck event) {
        if (event.getSpawner() != null) {
            ((LivingSoulData)event.getEntity().getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).setSpawnerSpawned(true);
        }
    }

    public static void syncData(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            ((LivingSoulData)mob.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).updateSoullessBehavior(mob);
        }
    }

    public static void preventTargeting(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            ((LivingSoulData)mob.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).updateSoullessTargeting(event);
        }
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((LivingSoulData)living.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).tickDuration();
        }
    }

    public static void exposeSoul(LivingDamageEvent.Post event) {
        LivingEntity attacker;
        ItemStack stack;
        ProjectileSoulData projectileData;
        if (event.getOriginalDamage() <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        LivingSoulData data = (LivingSoulData)target.getData(MalumAttachmentTypes.LIVING_SOUL_INFO);
        if (source.is(MalumTags.DamageTypeTags.SOUL_SHATTER_DAMAGE)) {
            data.setExposed();
            return;
        }
        Entity directEntity = source.getDirectEntity();
        if (directEntity != null && (projectileData = (ProjectileSoulData)directEntity.getData(MalumAttachmentTypes.PROJECTILE_SOUL_INFO)).dealsSoulDamage()) {
            data.setExposed();
            return;
        }
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && ((stack = SoulDataHandler.getSoulHunterWeapon(source, attacker = (LivingEntity)entity)).is(MalumTags.ItemTags.SOUL_SHATTER_CAPABLE_WEAPON) || TetraCompat.hasSoulStrikeModifier(stack))) {
            data.setExposed();
        }
    }

    public static ItemStack getStaffWeapon(DamageSource source, LivingEntity attacker) {
        return SoulDataHandler.getSoulHunterWeapon(source, attacker, s -> s.getItem() instanceof AbstractStaffItem);
    }

    public static ItemStack getScytheWeapon(DamageSource source, LivingEntity attacker) {
        return SoulDataHandler.getSoulHunterWeapon(source, attacker, s -> s.getItem() instanceof MalumScytheItem);
    }

    public static ItemStack getSoulHunterWeapon(DamageSource source, LivingEntity attacker, Predicate<ItemStack> predicate) {
        ItemStack soulHunterWeapon = SoulDataHandler.getSoulHunterWeapon(source, attacker);
        return predicate.test(soulHunterWeapon) ? soulHunterWeapon : ItemStack.EMPTY;
    }

    public static ItemStack getSoulHunterWeapon(DamageSource source, LivingEntity attacker) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof ScytheBoomerangEntity) {
            ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)entity;
            return scytheBoomerang.getItem();
        }
        return attacker.getMainHandItem();
    }
}

