/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlockEntity;
import com.sammy.malum.common.data.attachment.WindTunnelData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

public class WindTunnelHandler {
    public static final float MAX_STRENGTH = 32.0f;
    public static final ResourceLocation GRAVITY_MODIFIER_ID = MalumMod.malumPath("wind_tunnel_reduced_gravity");

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        entity.getExistingData(MalumAttachmentTypes.WIND_TUNNEL_INFO).ifPresent(d -> d.tickData(entity));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            WindTunnelHandler.updateLivingGravity(livingEntity);
        }
    }

    public static double modifyEntityGravity(Entity entity, double original) {
        return original * (double)entity.getExistingData(MalumAttachmentTypes.WIND_TUNNEL_INFO).map(WindTunnelData::getGravityMultiplier).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void updateLivingGravity(LivingEntity entity) {
        AttributeInstance gravity = entity.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            if (gravity.hasModifier(GRAVITY_MODIFIER_ID)) {
                gravity.removeModifier(GRAVITY_MODIFIER_ID);
            }
            WindTunnelHandler.getGravityAttributeModifier(entity).ifPresent(arg_0 -> ((AttributeInstance)gravity).addTransientModifier(arg_0));
        }
    }

    public static Optional<AttributeModifier> getGravityAttributeModifier(LivingEntity entity) {
        if (!entity.hasData(MalumAttachmentTypes.WIND_TUNNEL_INFO)) {
            return Optional.empty();
        }
        WindTunnelData data = (WindTunnelData)entity.getData(MalumAttachmentTypes.WIND_TUNNEL_INFO);
        float multiplier = data.getGravityMultiplier();
        if (multiplier >= 1.0f) {
            return Optional.empty();
        }
        return Optional.of(new AttributeModifier(GRAVITY_MODIFIER_ID, (double)(multiplier - 1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }

    public static boolean modifyTunnels(Level level, GustIgniterBlockEntity igniter, Function<BlockState, BlockState> stateModifier) {
        ArrayList<WindTunnelBlockEntity> unboundTunnels = new ArrayList<WindTunnelBlockEntity>();
        for (BlockPos tunnelPos : igniter.windTunnels) {
            BlockEntity blockEntity = level.getBlockEntity(tunnelPos);
            if (!(blockEntity instanceof WindTunnelBlockEntity)) continue;
            WindTunnelBlockEntity boundTunnel = (WindTunnelBlockEntity)blockEntity;
            boundTunnel.unbind();
            unboundTunnels.add(boundTunnel);
        }
        igniter.windTunnels.clear();
        Map<BlockPos, WindTunnelBlockEntity> windTunnels = WindTunnelHandler.findWindTunnels(level, igniter);
        if (windTunnels.isEmpty()) {
            WindTunnelHandler.revertTunnels(level, unboundTunnels);
            return false;
        }
        HashSet<BlockPos> tunnelPositions = new HashSet<BlockPos>();
        Direction windDirection = null;
        igniter.limiter = windTunnels.values().stream().mapToInt(e -> e.findLimit(igniter.strength)).min().orElse(igniter.strength);
        for (Map.Entry entry : windTunnels.entrySet()) {
            BlockPos tunnelPos = (BlockPos)entry.getKey();
            WindTunnelBlockEntity tunnel = (WindTunnelBlockEntity)((Object)entry.getValue());
            BlockState tunnelState = level.getBlockState(tunnelPos);
            BlockState modifiedState = stateModifier.apply(tunnelState);
            level.setBlock(tunnelPos, modifiedState, 2);
            if (WindTunnelBlock.isActive(modifiedState)) {
                igniter.bind(tunnel);
                tunnelPositions.add(tunnelPos);
            } else {
                igniter.unbind(tunnel);
            }
            unboundTunnels.remove((Object)tunnel);
            windDirection = (Direction)modifiedState.getValue((Property)WindTunnelBlock.FACING);
        }
        WindTunnelHandler.revertTunnels(level, unboundTunnels);
        if (tunnelPositions.isEmpty()) {
            igniter.windArea = null;
            igniter.windDirection = null;
            return false;
        }
        igniter.windArea = WindTunnelHandler.getWindArea(igniter, tunnelPositions, windDirection);
        igniter.windDirection = windDirection;
        igniter.setDirty();
        return true;
    }

    public static void revertTunnels(Level level, ArrayList<WindTunnelBlockEntity> tunnels) {
        for (WindTunnelBlockEntity tunnel : tunnels) {
            level.setBlock(tunnel.getBlockPos(), (BlockState)tunnel.getBlockState().setValue((Property)WindTunnelBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public static boolean isInArea(Entity entity, AABB windArea, Direction windDirection, Set<BlockPos> windTunnels) {
        if (windArea == null || windDirection == null) {
            return false;
        }
        Vec3 position = entity.position();
        Vec3 center = position.add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
        Direction.Axis axis = windDirection.getAxis();
        for (BlockPos tunnel : windTunnels) {
            Vec3 tunnelCenter = tunnel.getCenter();
            double x = axis.equals((Object)Direction.Axis.X) ? tunnelCenter.x : center.x;
            double y = axis.equals((Object)Direction.Axis.Y) ? tunnelCenter.y : center.y;
            double d = axis.equals((Object)Direction.Axis.Z) ? tunnelCenter.z : center.z;
            double z = d;
            Vec3 offsetPosition = new Vec3(x, y, z);
            if (!(offsetPosition.distanceTo(tunnelCenter) < 0.75)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static AABB getWindArea(GustIgniterBlockEntity igniter, HashSet<BlockPos> tunnelPositions, Direction tunnelDirection) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos tunnelPosition : tunnelPositions) {
            int x = tunnelPosition.getX();
            int y = tunnelPosition.getY();
            int z = tunnelPosition.getZ();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        AABB area = new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
        int x = tunnelDirection.getStepX();
        int y = tunnelDirection.getStepY();
        int z = tunnelDirection.getStepZ();
        Vec3 offset = new Vec3((double)x, (double)y, (double)z).scale((double)igniter.getTunnelLength());
        return area.expandTowards(offset).inflate(0.25);
    }

    public static Map<BlockPos, WindTunnelBlockEntity> findWindTunnels(Level level, GustIgniterBlockEntity igniter) {
        WindTunnelBlockEntity startingTunnel;
        Direction facing;
        BlockState igniterState = igniter.getBlockState();
        BlockPos igniterPos = igniter.getBlockPos();
        BlockPos startPos = igniterPos.relative(facing = (Direction)igniterState.getValue((Property)AbstractGustGizmoBlock.FACING));
        BlockEntity blockEntity = level.getBlockEntity(startPos);
        if (blockEntity instanceof WindTunnelBlockEntity && !(startingTunnel = (WindTunnelBlockEntity)blockEntity).isRemoved()) {
            return WindTunnelHandler.findWindTunnels(level, startingTunnel, t -> t.canIgnite(igniter));
        }
        return Collections.emptyMap();
    }

    public static HashMap<BlockPos, WindTunnelBlockEntity> findWindTunnels(Level level, WindTunnelBlockEntity startingTunnel, Predicate<WindTunnelBlockEntity> condition) {
        BlockPos startPos = startingTunnel.getBlockPos();
        Direction facing = (Direction)startingTunnel.getBlockState().getValue((Property)AbstractGustGizmoBlock.FACING);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashMap<BlockPos, WindTunnelBlockEntity> result = new HashMap<BlockPos, WindTunnelBlockEntity>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        if (condition.test(startingTunnel)) {
            result.put(startPos, startingTunnel);
            queue.add(startPos);
            visited.add(startPos);
        }
        ArrayList<Direction> directionsToCheck = new ArrayList<Direction>(List.of(Direction.values()));
        directionsToCheck.remove(facing);
        directionsToCheck.remove(facing.getOpposite());
        BlockPos.MutableBlockPos mutable = startPos.mutable();
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            for (Direction direction : directionsToCheck) {
                Direction otherFacing;
                WindTunnelBlockEntity nextTunnel;
                BlockEntity blockEntity;
                mutable.set((Vec3i)pos).move(direction);
                if (visited.contains(mutable) || !((blockEntity = level.getBlockEntity((BlockPos)mutable)) instanceof WindTunnelBlockEntity) || (nextTunnel = (WindTunnelBlockEntity)blockEntity).isRemoved() || (otherFacing = (Direction)nextTunnel.getBlockState().getValue((Property)WindTunnelBlock.FACING)) != facing || !condition.test(nextTunnel)) continue;
                BlockPos immutable = mutable.immutable();
                visited.add(immutable);
                result.put(immutable, nextTunnel);
                queue.add(immutable);
            }
        }
        return result;
    }
}

