/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.hiding;

import com.sammy.malum.common.item.GeasItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.registry.common.MalumTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HiddenTagHandler {
    private static final Map<TagKey<Item>, BooleanSupplier> ITEMS_TO_HIDE = new HashMap<TagKey<Item>, BooleanSupplier>();
    private static final HashMap<UUID, Runnable> INVOKED_WHEN_CONDITIONS_CHANGE = new HashMap();

    public static void hideTagWhen(TagKey<Item> item, BooleanSupplier condition) {
        ITEMS_TO_HIDE.put(item, condition);
    }

    public static UUID registerHiddenItemListener(Runnable runnable) {
        runnable.run();
        UUID uuid = UUID.randomUUID();
        INVOKED_WHEN_CONDITIONS_CHANGE.put(uuid, runnable);
        return uuid;
    }

    public static void removeListener(UUID listener) {
        INVOKED_WHEN_CONDITIONS_CHANGE.remove(listener);
    }

    public static void conditionsChanged() {
        INVOKED_WHEN_CONDITIONS_CHANGE.values().forEach(Runnable::run);
    }

    public static void hideItems(Collection<ItemStack> items) {
        if (!((Boolean)CommonConfig.HIDE_RECIPES.getConfigValue()).booleanValue()) {
            return;
        }
        items.removeIf(HiddenTagHandler::isHiddenItem);
    }

    public static boolean isHiddenItem(ItemStack stack) {
        if (stack.getItem() instanceof GeasItem && ITEMS_TO_HIDE.get(MalumTags.ItemTags.HIDDEN_UNTIL_BLACK_CRYSTAL).getAsBoolean()) {
            return GeasEffectHandler.getStoredGeasEffect(stack).map(g -> g.geasEffectType().is(MalumTags.GeasTags.HIDDEN_UNTIL_BLACK_CRYSTAL)).orElse(false);
        }
        for (TagKey<Item> tag : HiddenTagHandler.getTagsToHide()) {
            if (!stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public static List<TagKey<Item>> getTagsToHide() {
        ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
        for (Map.Entry<TagKey<Item>, BooleanSupplier> entry : ITEMS_TO_HIDE.entrySet()) {
            if (!entry.getValue().getAsBoolean()) continue;
            tags.add(entry.getKey());
        }
        return tags;
    }
}

