/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

public class SpellweavingEqualityReloadListener
extends SimpleJsonResourceReloadListener {
    public static List<SpellweavingEqualityData> EQUALITY_DATA = new ArrayList<SpellweavingEqualityData>();
    private static final Gson GSON = new GsonBuilder().create();

    public SpellweavingEqualityReloadListener() {
        super(GSON, "spellweaving_data");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SpellweavingEqualityReloadListener());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        EQUALITY_DATA.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonArray array = objectIn.get(location).getAsJsonArray();
            ArrayList<Holder<Block>> blocks = new ArrayList<Holder<Block>>();
            for (JsonElement block : array) {
                String name = block.getAsString();
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)name));
                Optional holder = BuiltInRegistries.BLOCK.getHolder(key);
                holder.ifPresent(blocks::add);
            }
            EQUALITY_DATA.add(new SpellweavingEqualityData(blocks));
        }
    }

    public record SpellweavingEqualityData(List<Holder<Block>> equalBlocks) {
    }
}

