/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.mojang.serialization.Codec;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeValue;
import com.sammy.malum.core.systems.artifice.TuningBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ArtificeAttributeType {
    public static final ArrayList<ArtificeAttributeType> CRUCIBLE_ATTRIBUTES = new ArrayList();
    public static final Codec<ArtificeAttributeType> CODEC = ResourceLocation.CODEC.xmap(ArtificeAttributeType::getAttribute, f -> f.id);
    public static final ArtificeAttributeType FOCUSING_SPEED = ArtificeAttributeType.create(MalumMod.malumPath("focusing_speed"), d -> d.focusingSpeed).setDefaultValue(1.0f).build();
    public static final ArtificeAttributeType FUEL_USAGE_RATE = ArtificeAttributeType.create(MalumMod.malumPath("fuel_usage_rate"), d -> d.fuelUsageRate).withRequirement((d, v) -> d.demandsFuel && v.getValue((ArtificeAttributeData)d) > 0.0f).setDefaultValue(1.0f).invertedTuning().build();
    public static final ArtificeAttributeType INSTABILITY = ArtificeAttributeType.create(MalumMod.malumPath("instability"), d -> d.instability).setDefaultValue(0.2f).invertedTuning().build();
    public static final ArtificeAttributeType FORTUNE_CHANCE = ArtificeAttributeType.create(MalumMod.malumPath("fortune_chance"), d -> d.fortuneChance).build();
    public static final ArtificeAttributeType CHAIN_FOCUSING_CHANCE = ArtificeAttributeType.create(MalumMod.malumPath("chain_focusing_chance"), d -> d.chainFocusingChance).build();
    public static final ArtificeAttributeType DAMAGE_ABSORPTION_CHANCE = ArtificeAttributeType.create(MalumMod.malumPath("damage_absorption_chance"), d -> d.damageAbsorptionChance).build();
    public static final ArtificeAttributeType RESTORATION_CHANCE = ArtificeAttributeType.create(MalumMod.malumPath("restoration_chance"), d -> d.restorationChance).build();
    public static final ArtificeAttributeType WEAKNESS_TUNING = ArtificeAttributeType.create(MalumMod.malumPath("weakness_tuning"), d -> d.weaknessTuning).noTuning().build();
    public static final ArtificeAttributeType TUNING_POTENCY = ArtificeAttributeType.create(MalumMod.malumPath("tuning_potency"), d -> d.tuningPotency).setDefaultValue(1.0f).noTuning().build();
    public static final ArtificeAttributeType TUNING_STRAIN = ArtificeAttributeType.create(MalumMod.malumPath("tuning_strain"), d -> d.tuningStrain).setDefaultValue(1.0f).noTuning().build();
    public static final ArtificeAttributeType CAUSTIC_SYNERGY = ArtificeAttributeType.create(MalumMod.malumPath("caustic_synergy"), d -> d.causticSynergy).noTuning().build();
    public static final ArtificeAttributeType RESONANCE_TUNING = ArtificeAttributeType.create(MalumMod.malumPath("resonance_tuning"), d -> d.resonanceTuning).noTuning().build();
    public static final ArtificeAttributeType MISFORTUNE_REVERSAL = ArtificeAttributeType.create(MalumMod.malumPath("misfortune_reversal"), d -> d.misfortuneReversal).noTuning().build();
    protected final ResourceLocation id;
    protected final Function<ArtificeAttributeData, ArtificeAttributeValue> valueGetter;
    protected final BiPredicate<ArtificeAttributeData, ArtificeAttributeValue> valueValidator;
    protected final TuningBehavior tuningBehavior;
    protected final float defaultValue;

    public ArtificeAttributeType(ResourceLocation id, Function<ArtificeAttributeData, ArtificeAttributeValue> valueGetter, BiPredicate<ArtificeAttributeData, ArtificeAttributeValue> valueValidator, @Nullable TuningBehavior tuningBehavior, float defaultValue) {
        this.id = id;
        this.valueGetter = valueGetter;
        this.valueValidator = valueValidator;
        this.tuningBehavior = tuningBehavior;
        this.defaultValue = defaultValue;
        CRUCIBLE_ATTRIBUTES.add(this);
    }

    public ArtificeAttributeValue getAttributeValue(ArtificeAttributeData data) {
        return this.valueGetter.apply(data);
    }

    public String getDataPrint(ArtificeAttributeData data) {
        return Math.round(this.getAttributeValue(data).getValue(data) * 100.0f) + "%";
    }

    public boolean isValueValid(ArtificeAttributeData data) {
        return this.valueValidator.test(data, data.getAttributeValue(this));
    }

    public boolean canBeTuned() {
        return this.tuningBehavior != null;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public TuningBehavior getTuningBehavior() {
        return this.tuningBehavior;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public String getLangKey() {
        return this.id.getNamespace() + ".gui.crucible.attribute." + this.id.getPath();
    }

    public static List<ArtificeAttributeType> getExistingAttributes(ArtificeAttributeData data) {
        ArrayList<ArtificeAttributeType> attributes = new ArrayList<ArtificeAttributeType>();
        for (ArtificeAttributeType attributeType : CRUCIBLE_ATTRIBUTES) {
            if (!attributeType.isValueValid(data)) continue;
            attributes.add(attributeType);
        }
        return attributes;
    }

    public static ArtificeAttributeType getAttribute(ResourceLocation resourceLocation) {
        for (ArtificeAttributeType attributeType : CRUCIBLE_ATTRIBUTES) {
            if (!attributeType.id.equals((Object)resourceLocation)) continue;
            return attributeType;
        }
        return null;
    }

    public static ArtificeAttributeTypeBuilder create(ResourceLocation id, Function<ArtificeAttributeData, ArtificeAttributeValue> valueGetter) {
        return new ArtificeAttributeTypeBuilder(id, valueGetter);
    }

    public static class ArtificeAttributeTypeBuilder {
        private final ResourceLocation id;
        private final Function<ArtificeAttributeData, ArtificeAttributeValue> valueGetter;
        private BiPredicate<ArtificeAttributeData, ArtificeAttributeValue> valueValidator = (d, v) -> v.getValue((ArtificeAttributeData)d) > 0.0f;
        private float defaultValue;
        private TuningBehavior tuningBehavior = TuningBehavior.STANDARD;

        public ArtificeAttributeTypeBuilder(ResourceLocation id, Function<ArtificeAttributeData, ArtificeAttributeValue> valueGetter) {
            this.id = id;
            this.valueGetter = valueGetter;
        }

        public ArtificeAttributeTypeBuilder withRequirement(BiPredicate<ArtificeAttributeData, ArtificeAttributeValue> valueValidator) {
            this.valueValidator = valueValidator;
            return this;
        }

        public ArtificeAttributeTypeBuilder setDefaultValue(float defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ArtificeAttributeTypeBuilder invertedTuning() {
            this.tuningBehavior = TuningBehavior.INVERSE;
            return this;
        }

        public ArtificeAttributeTypeBuilder noTuning() {
            this.tuningBehavior = null;
            return this;
        }

        public ArtificeAttributeType build() {
            return new ArtificeAttributeType(this.id, this.valueGetter, this.valueValidator, this.tuningBehavior, this.defaultValue);
        }
    }
}

