/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.geas;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class GeasEffect
implements IMalumEventResponder {
    public final GeasEffectType type;
    private boolean isDirty = true;
    private Multimap<Holder<Attribute>, AttributeModifier> attributeCache;

    public GeasEffect(GeasEffectType type) {
        this.type = type;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        this.createAttributeModifiers(entity).entries().forEach(entry -> this.addTooltipComponent((Map.Entry<Holder<Attribute>, AttributeModifier>)entry, tooltipAcceptor, tooltipFlag));
    }

    public final void addTooltipComponent(Map.Entry<Holder<Attribute>, AttributeModifier> entry, Consumer<Component> tooltipAcceptor, TooltipFlag flag) {
        Holder<Attribute> holder = entry.getKey();
        Attribute attribute = (Attribute)holder.value();
        AttributeModifier attributeModifier = entry.getValue();
        tooltipAcceptor.accept((Component)attribute.toComponent(attributeModifier, flag));
    }

    protected Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity) {
        return this.createAttributeModifiers(entity, (Multimap<Holder<Attribute>, AttributeModifier>)LinkedHashMultimap.create());
    }

    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        return LinkedHashMultimap.create();
    }

    public void addAttributeModifier(Multimap<Holder<Attribute>, AttributeModifier> modifiers, Holder<Attribute> attribute, double value, AttributeModifier.Operation operation) {
        modifiers.put(attribute, (Object)new AttributeModifier(this.getModifierId(), value, operation));
    }

    public ResourceLocation getModifierId() {
        return this.type.getRegistryName().withPrefix(this.type.getRegistryName().getPath() + "_");
    }

    public final void updateAttributes(LivingEntity entity) {
        if (this.isDirty) {
            this.applyAttributeModifiers(entity);
            this.isDirty = false;
        }
    }

    public void removeAttributeModifiers(LivingEntity entity) {
        if (this.attributeCache != null) {
            entity.getAttributes().removeAttributeModifiers(this.attributeCache);
        }
    }

    protected void applyAttributeModifiers(LivingEntity entity) {
        this.removeAttributeModifiers(entity);
        Multimap<Holder<Attribute>, AttributeModifier> attributes = this.createAttributeModifiers(entity);
        entity.getAttributes().addTransientAttributeModifiers(attributes);
        this.attributeCache = attributes;
    }

    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
    }
}

