/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.recipe;

import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public class SpiritBasedRecipeInput
implements RecipeInput {
    public final List<ItemStack> items;
    public final List<ItemStack> spirits;

    public SpiritBasedRecipeInput(ItemStack stack, ItemStack spirit) {
        this(stack, List.of(spirit));
    }

    public SpiritBasedRecipeInput(ItemStack stack, List<ItemStack> spirits) {
        this(List.of(stack), spirits);
    }

    public SpiritBasedRecipeInput(List<ItemStack> items, List<ItemStack> spirits) {
        this.items = items;
        this.spirits = spirits;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return index < this.items.size() ? this.items.get(index) : this.spirits.get(index - this.items.size());
    }

    public int size() {
        return this.items.size() + this.spirits.size();
    }

    public boolean test(SizedIngredient mainIngredient, List<SizedIngredient> extraIngredients, List<SpiritIngredient> spirits) {
        ArrayList<SizedIngredient> ingredients = new ArrayList<SizedIngredient>(List.of(mainIngredient));
        ingredients.addAll(extraIngredients);
        return this.test(ingredients, spirits);
    }

    public boolean test(SizedIngredient ingredient, SpiritIngredient spirit) {
        return this.test(ingredient, List.of(spirit));
    }

    public boolean test(SizedIngredient ingredient, List<SpiritIngredient> spirits) {
        return this.test(List.of(ingredient), spirits);
    }

    public boolean test(List<SizedIngredient> ingredients, List<SpiritIngredient> spirits) {
        return this.testItems(ingredients) && this.testSpirits(spirits);
    }

    public boolean testItems(List<SizedIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return true;
        }
        if (this.items.size() != ingredients.size()) {
            return false;
        }
        List<ItemStack> sortedStacks = this.sortItems(ingredients);
        if (sortedStacks.size() < this.items.size()) {
            return false;
        }
        for (int i = 0; i < sortedStacks.size(); ++i) {
            ItemStack stack;
            SizedIngredient ingredient = ingredients.get(i);
            if (ingredient.test(stack = sortedStacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean testSpirits(List<SpiritIngredient> recipeSpirits) {
        if (recipeSpirits.isEmpty()) {
            return true;
        }
        if (this.spirits.size() != recipeSpirits.size()) {
            return false;
        }
        List<ItemStack> sortedStacks = this.sortSpirits(recipeSpirits);
        if (sortedStacks.size() < this.spirits.size()) {
            return false;
        }
        for (int i = 0; i < sortedStacks.size(); ++i) {
            ItemStack stack;
            SpiritIngredient ingredient = recipeSpirits.get(i);
            if (ingredient.test(stack = sortedStacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> sortSpirits(List<SpiritIngredient> recipeSpirits) {
        ArrayList<ItemStack> sortedStacks = new ArrayList<ItemStack>();
        block0: for (SpiritIngredient ingredient : recipeSpirits) {
            for (ItemStack stack : this.spirits) {
                if (!ingredient.test(stack)) continue;
                sortedStacks.add(stack);
                continue block0;
            }
        }
        return sortedStacks;
    }

    public List<ItemStack> sortItems(List<SizedIngredient> recipeIngredients) {
        ArrayList<ItemStack> sortedStacks = new ArrayList<ItemStack>();
        block0: for (SizedIngredient ingredient : recipeIngredients) {
            for (ItemStack stack : this.items) {
                if (!ingredient.test(stack)) continue;
                sortedStacks.add(stack);
                continue block0;
            }
        }
        return sortedStacks;
    }
}

