/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite.effect;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.core.systems.registry.RegistryCodecBuddy;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.rite.MalumSpiritRiteEffectTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public abstract class SpiritRiteEffect
implements RegistryCodecBuddy.RegistryCodecBuddyHelper<SpiritRiteEffect> {
    public static final RegistryCodecBuddy<SpiritRiteEffect> CODEC = new RegistryCodecBuddy<SpiritRiteEffect>(MalumSpiritRiteEffectTypes.EFFECT_TYPE_REGISTRY, "spirit_rite_effect");
    protected final List<SpiritRiteEffectTag> tags;

    protected SpiritRiteEffect(SpiritRiteEffectTag ... tags) {
        this((List<SpiritRiteEffectTag>)ImmutableList.copyOf(Arrays.asList(tags)));
    }

    protected SpiritRiteEffect(List<SpiritRiteEffectTag> tags) {
        this.tags = ImmutableList.copyOf(tags);
    }

    public abstract boolean triggerRiteEffect(ServerLevel var1, BlockPos var2, SpiritArcanaType var3, RiteParameters var4);

    public List<SpiritRiteEffectTag> getTags() {
        return this.tags;
    }

    public ResourceLocation getRegistryName() {
        return MalumSpiritRiteEffectTypes.EFFECT_TYPE_REGISTRY.getKey((Object)this);
    }

    public int getCooldown() {
        return 100;
    }

    @Override
    public RegistryCodecBuddy<SpiritRiteEffect> getCodec() {
        return CODEC;
    }

    public static RiteParametersBuilder builder() {
        return new RiteParametersBuilder();
    }

    public static class RiteParametersBuilder {
        private int totemHeight = 0;
        private Direction totemDirection = Direction.NORTH;

        public RiteParametersBuilder setTotemHeight(int totemHeight) {
            this.totemHeight = totemHeight;
            return this;
        }

        public RiteParametersBuilder setTotemDirection(Direction totemDirection) {
            this.totemDirection = totemDirection;
            return this;
        }

        public RiteParameters build() {
            return new RiteParameters(this.totemHeight, this.totemDirection);
        }
    }

    public static class RiteParameters {
        private final int totemHeight;
        private final Direction totemDirection;

        public RiteParameters(int totemHeight, Direction totemDirection) {
            this.totemHeight = totemHeight;
            this.totemDirection = totemDirection;
        }

        public int getTotemHeight() {
            return this.totemHeight;
        }

        public Optional<Direction> getTotemDirection() {
            return Optional.ofNullable(this.totemDirection);
        }
    }
}

