/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EntitySpiritDropData {
    public static final EntitySpiritDropData EMPTY = new EntitySpiritDropData(MalumSpiritTypes.SACRED_SPIRIT, new ArrayList<SpiritIngredient>(), null);
    protected final SpiritHolder<SpiritArcanaType> primaryType;
    protected final int totalSpirits;
    protected final List<SpiritIngredient> spirits;
    @Nullable
    protected final Ingredient itemAsSoul;

    public EntitySpiritDropData(SpiritHolder<SpiritArcanaType> primaryType, List<SpiritIngredient> spirits, @Nullable Ingredient itemAsSoul) {
        this.primaryType = primaryType;
        this.totalSpirits = spirits.stream().mapToInt(SpiritIngredient::count).sum();
        this.spirits = spirits;
        this.itemAsSoul = itemAsSoul;
    }

    public static List<ItemStack> getSpiritStacks(LivingEntity entity) {
        return EntitySpiritDropData.getSpiritData(entity).map(EntitySpiritDropData::getSpiritStacks).orElse(Collections.emptyList());
    }

    public SpiritHolder<SpiritArcanaType> getPrimaryType() {
        return this.primaryType;
    }

    public int getTotalSpirits() {
        return this.totalSpirits;
    }

    public List<SpiritIngredient> getSpirits() {
        return this.spirits;
    }

    public List<ItemStack> getSpiritStacks() {
        return this.spirits.stream().map(SpiritIngredient::asItemStack).collect(Collectors.toList());
    }

    @Nullable
    public Ingredient getItemAsSoul() {
        return this.itemAsSoul;
    }

    public static Optional<EntitySpiritDropData> getSpiritData(LivingEntity entity) {
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (SpiritDataReloadListener.HAS_NO_DATA.contains(key)) {
            return Optional.empty();
        }
        EntitySpiritDropData spiritData = SpiritDataReloadListener.SPIRIT_DATA.get(key);
        if (spiritData != null) {
            return Optional.of(spiritData);
        }
        if (entity.getMaxHealth() >= 60.0f) {
            return Optional.of(SpiritDataReloadListener.DEFAULT_BOSS_SPIRIT_DATA);
        }
        if (!((Boolean)CommonConfig.USE_DEFAULT_SPIRIT_VALUES.getConfigValue()).booleanValue()) {
            return Optional.empty();
        }
        return switch (entity.getType().getCategory()) {
            case MobCategory.MONSTER -> Optional.of(SpiritDataReloadListener.DEFAULT_MONSTER_SPIRIT_DATA);
            case MobCategory.CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_CREATURE_SPIRIT_DATA);
            case MobCategory.AMBIENT -> Optional.of(SpiritDataReloadListener.DEFAULT_AMBIENT_SPIRIT_DATA);
            case MobCategory.AXOLOTLS -> Optional.of(SpiritDataReloadListener.DEFAULT_AXOLOTL_SPIRIT_DATA);
            case MobCategory.UNDERGROUND_WATER_CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_UNDERGROUND_WATER_CREATURE_SPIRIT_DATA);
            case MobCategory.WATER_CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_CREATURE_SPIRIT_DATA);
            case MobCategory.WATER_AMBIENT -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_AMBIENT_SPIRIT_DATA);
            default -> Optional.empty();
        };
    }

    public static Builder builder(SpiritHolder<SpiritArcanaType> type) {
        return EntitySpiritDropData.builder(type, 1);
    }

    public static Builder builder(SpiritHolder<SpiritArcanaType> type, int count) {
        return new Builder(type).withSpirit(type, count);
    }

    public static class Builder {
        private final SpiritHolder<SpiritArcanaType> primaryType;
        private final List<SpiritIngredient> spirits = new ArrayList<SpiritIngredient>();
        private Ingredient itemAsSoul = null;

        public Builder(SpiritHolder<SpiritArcanaType> primaryType) {
            this.primaryType = primaryType;
        }

        public Builder withSpirit(SpiritHolder<SpiritArcanaType> spiritType) {
            return this.withSpirit(spiritType, 1);
        }

        public Builder withSpirit(SpiritHolder<SpiritArcanaType> spirit, int count) {
            this.spirits.add(new SpiritIngredient((Holder<SpiritArcanaType>)spirit, count));
            return this;
        }

        public Builder withItemAsSoul(Ingredient itemAsSoul) {
            this.itemAsSoul = itemAsSoul;
            return this;
        }

        public EntitySpiritDropData build() {
            return new EntitySpiritDropData(this.primaryType, this.spirits, this.itemAsSoul);
        }
    }
}

