/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit.type;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritColorProperties;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class SpiritArcanaType
implements SpiritLike {
    public static final Codec<Holder<SpiritArcanaType>> HOLDER_CODEC = MalumSpiritTypes.SPIRIT_TYPES_REGISTRY.holderByNameCodec();
    public static final Codec<SpiritArcanaType> CODEC = MalumSpiritTypes.SPIRIT_TYPES_REGISTRY.byNameCodec();
    public static StreamCodec<ByteBuf, SpiritArcanaType> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private final SpiritColorProperties colorProperties;
    private final DeferredHolder<Item, SpiritShardItem> spiritShard;
    protected Rarity itemRarity;
    protected ResourceLocation glowTexture;

    public SpiritArcanaType(SpiritColorProperties colorProperties, DeferredHolder<Item, SpiritShardItem> spiritShard) {
        this.colorProperties = colorProperties;
        this.spiritShard = spiritShard;
    }

    @Override
    @NotNull
    public SpiritArcanaType getSpirit() {
        return this;
    }

    @Override
    public SpiritShardItem getSpiritShard() {
        return (SpiritShardItem)this.spiritShard.value();
    }

    public SpiritColorProperties getColorProperties() {
        return this.colorProperties;
    }

    public Rarity getItemRarity() {
        if (this.itemRarity == null) {
            TextColor textColor = this.getTextColor(false);
            this.itemRarity = Rarity.UNCOMMON;
        }
        return this.itemRarity;
    }

    public ResourceLocation getGlowTexture() {
        if (this.glowTexture == null) {
            this.glowTexture = this.getRegistryName().withPath(p -> "textures/vfx/totem_poles/" + p).withSuffix("_glow.png");
        }
        return this.glowTexture;
    }

    public final void save(CompoundTag tag) {
        this.save(tag, "spirit");
    }

    public final void save(CompoundTag tag, String name) {
        tag.put(name, (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow());
    }

    public static Optional<SpiritArcanaType> load(CompoundTag tag) {
        return SpiritArcanaType.load(tag, "spirit");
    }

    public static Optional<SpiritArcanaType> load(CompoundTag tag, String name) {
        return CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(name)).map(Pair::getFirst).result();
    }
}

