/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.item;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.component.ItemSkinComponent;
import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmithResult;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;
import team.lodestar.lodestone.systems.item.LodestoneArmorItem;

public class MalumItemModelSmithTypes
extends ItemModelSmithTypes {
    public static final ResourceLocation LARGE_HANDHELD = MalumMod.malumPath("item/handheld_large");
    public static final Consumer<ItemModelSmithResult> HUGE_ITEM = result -> {
        LodestoneItemModelProvider provider = result.getProvider();
        ExistingFileHelper existingFileHelper = provider.existingFileHelper;
        SeparateTransformsModelBuilder separateTransforms = result.addSeparateTransformData();
        ItemModelSmithResult firstPersonModel = ((ItemModelSmith)PARENTED_ITEM.apply(LARGE_HANDHELD)).addModelNameAffix("_huge").addTextureNameAffix("_huge").act(provider, () -> ((ItemModelSmithResult)result).getItem());
        ItemModelSmithResult guiModel = ItemModelSmithTypes.GENERATED_ITEM.addModelNameAffix("_gui").act(provider, () -> ((ItemModelSmithResult)result).getItem());
        separateTransforms.perspective(ItemDisplayContext.GUI, (ModelBuilder)guiModel.parentedToThis(existingFileHelper));
        separateTransforms.perspective(ItemDisplayContext.FIXED, (ModelBuilder)guiModel.parentedToThis(existingFileHelper));
        separateTransforms.base((ModelBuilder)firstPersonModel.parentedToThis(existingFileHelper));
    };
    public static ItemModelSmith LARGE_HANDHELD_ITEM = ((ItemModelSmith)PARENTED_ITEM.apply(LARGE_HANDHELD)).modifyResult(HUGE_ITEM);
    public static ItemModelSmith IMPETUS_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        List split = (List)DataHelper.reverseOrder(new ArrayList(), Arrays.asList(name.split("_")));
        split.removeFirst();
        String alteredName = String.join((CharSequence)"_", split);
        return provider.createGenericModel(item, GENERATED, new ResourceLocation[]{provider.getItemTexture(alteredName)});
    });
    public static ItemModelSmith SOULWOVEN_POUCH = new ItemModelSmith((item, provider) -> {
        String base = provider.getItemName(item);
        ResourceLocation texture = provider.getItemTexture(base);
        provider.createGenericModel(item, GENERATED, new ResourceLocation[]{texture});
        return provider.getBuilder(BuiltInRegistries.ITEM.getKey((Object)item).getPath()).override().predicate(MalumMod.malumPath("filled"), 1.0f).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(base + "_filled", HANDHELD)).texture("layer0", texture.withSuffix("_filled"))).end();
    });
    public static ItemModelSmith SOULWOVEN_BANNER = new ItemModelSmith((item, provider) -> {
        String base = provider.getItemName(item);
        ItemModelBuilder model = provider.createGenericModel(item, GENERATED, new ResourceLocation[]{provider.getItemTexture(base + "_default")});
        for (SoulwovenBannerPatternDataComponent pattern : SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS) {
            int i = SoulwovenBannerPatternDataComponent.REGISTERED_PATTERNS.indexOf(pattern);
            if (pattern.equals(SoulwovenBannerPatternDataComponent.DEFAULT)) continue;
            String path = base + "_" + pattern.type().getPath();
            ResourceLocation itemTexturePath = provider.getItemTexture(path);
            provider.getBuilder(BuiltInRegistries.ITEM.getKey((Object)item).getPath()).override().predicate(MalumMod.malumPath("pattern"), (float)i).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(path, GENERATED)).texture("layer0", itemTexturePath)).end();
        }
        return model;
    });
    public static ItemModelSmith CATALYST_LOBBER = new ItemModelSmith((item, provider) -> {
        String base = provider.getItemName(item);
        ItemModelBuilder model = provider.createGenericModel(item, HANDHELD, new ResourceLocation[]{provider.getItemTexture(base)});
        for (int i = 1; i <= 2; ++i) {
            String affix = i == 1 ? "open" : "loaded";
            ResourceLocation itemTexturePath = provider.getItemTexture(base + "_" + affix);
            provider.getBuilder(BuiltInRegistries.ITEM.getKey((Object)item).getPath()).override().predicate(MalumMod.malumPath("state"), (float)i).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(base + "_" + affix, HANDHELD)).texture("layer0", itemTexturePath)).end();
        }
        return model;
    });
    public static ItemModelSmith SPELLWEAVING_TOOL = new ItemModelSmith((item, provider) -> {
        String base = provider.getItemName(item);
        ItemModelBuilder model = provider.createGenericModel(item, HANDHELD, new ResourceLocation[]{provider.getItemTexture(base)});
        String primed = base + "_primed";
        provider.getBuilder(BuiltInRegistries.ITEM.getKey((Object)item).getPath()).override().predicate(MalumMod.malumPath("primed"), 1.0f).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(primed, HANDHELD)).texture("layer0", provider.getItemTexture(primed))).end();
        return model;
    });
    public static ItemModelSmith UMBRAL_SPIRIT_ITEM = new ItemModelSmith((item, provider) -> provider.createGenericModel(item, GENERATED, new ResourceLocation[]{provider.getItemTexture("umbral_spirit_shard")}));
    public static ItemModelSmith SPIRIT_ITEM = new ItemModelSmith((item, provider) -> provider.createGenericModel(item, GENERATED, new ResourceLocation[]{provider.getItemTexture("spirit_shard")}));
    public static ItemModelSmith GENERATED_OVERLAY_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, GENERATED)).texture("layer0", provider.getItemTexture(name))).texture("layer1", provider.getItemTexture(name + "_overlay"));
    });
    public static ItemModelSmith HANDHELD_OVERLAY_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, HANDHELD)).texture("layer0", provider.getItemTexture(name))).texture("layer1", provider.getItemTexture(name + "_overlay"));
    });
    public static ItemModelSmith ETHER_BRAZIER_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        String rockType = name.split("_")[0];
        String brazierName = rockType + "_ether_brazier";
        String overlayName = name.replace(rockType + "_", "");
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, GENERATED)).texture("layer0", provider.getItemTexture(brazierName))).texture("layer1", provider.getItemTexture(overlayName + "_overlay"));
    });
    public static ItemModelSmith IRIDESCENT_ETHER_BRAZIER_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        String rockType = name.split("_")[0];
        String brazierName = rockType + "_ether_brazier";
        String overlayName = name.replace(rockType + "_", "");
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, GENERATED)).texture("layer0", provider.getItemTexture(brazierName))).texture("layer1", provider.getItemTexture(overlayName))).texture("layer2", provider.getItemTexture(overlayName + "_overlay"));
    });
    public static ItemModelSmith IRIDESCENT_ETHER_TORCH_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, HANDHELD)).texture("layer0", provider.getItemTexture("ether_torch"))).texture("layer1", provider.getItemTexture(name))).texture("layer2", provider.getItemTexture(name + "_overlay"));
    });
    public static ItemModelSmith SKIN_APPLICABLE_ARMOR_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        ItemModelBuilder model = provider.createGenericModel(item, GENERATED, new ResourceLocation[]{provider.getItemTexture(name)});
        for (ItemSkinComponent registeredSkin : ItemSkinComponent.REGISTERED_SKINS) {
            int index = registeredSkin.id();
            LodestoneArmorItem armorItem = (LodestoneArmorItem)item;
            ResourceLocation itemTexture = index < 18 ? MalumItemModelSmithTypes.getDefaultPrideTexturePath(registeredSkin, armorItem) : MalumItemModelSmithTypes.getDefaultTexturePath(registeredSkin, armorItem);
            String[] split = itemTexture.getPath().split("/");
            String modelName = split[split.length - 1];
            provider.getBuilder(BuiltInRegistries.ITEM.getKey((Object)item).getPath()).override().predicate(MalumMod.malumPath("item_skin"), (float)index).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(modelName, GENERATED)).texture("layer0", itemTexture)).end();
        }
        return model;
    });
    public static ItemModelSmith WEEPING_WELL_BLOCK_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        return (ItemModelBuilder)provider.getBuilder(name).parent((ModelFile)new ModelFile.UncheckedModelFile(provider.modLoc("block/weeping_well/" + name)));
    });
    public static ItemModelSmith LAYERED_WEEPING_WELL_BLOCK_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        return (ItemModelBuilder)provider.getBuilder(name).parent((ModelFile)new ModelFile.UncheckedModelFile(provider.modLoc("block/weeping_well/" + name + "_0")));
    });

    public static ResourceLocation getDefaultPrideTexturePath(ItemSkinComponent skin, LodestoneArmorItem item) {
        ResourceLocation path = MalumMod.malumPath("item/cosmetic/armor_icons/pride/" + skin.name().getPath());
        switch (item.getEquipmentSlot()) {
            case HEAD: {
                return path.withSuffix("_beanie");
            }
            case CHEST: {
                return path.withSuffix("_hoodie");
            }
            case LEGS: {
                return path.withSuffix("_shorts");
            }
            case FEET: {
                return path.withSuffix("_socks");
            }
        }
        return null;
    }

    public static ResourceLocation getDefaultTexturePath(ItemSkinComponent skin, LodestoneArmorItem item) {
        ResourceLocation path = MalumMod.malumPath("item/cosmetic/armor_icons/" + skin.name().getPath());
        switch (item.getEquipmentSlot()) {
            case HEAD: {
                return path.withSuffix("_head");
            }
            case CHEST: {
                return path.withSuffix("_body");
            }
            case LEGS: {
                return path.withSuffix("_legs");
            }
            case FEET: {
                return path.withSuffix("_feet");
            }
        }
        return null;
    }
}

