/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.recipe.spirit_repair.SpiritRepairRegexData;
import com.sammy.malum.datagen.recipe.MalumRecipes;
import com.sammy.malum.datagen.recipe.builder.SpiritRepairRecipeBuilder;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class MalumSpiritRepairRecipes
implements IConditionBuilder {
    protected static void buildRecipes(RecipeOutput recipeOutput) {
        Criterion<InventoryChangeTrigger.TriggerInstance> has = MalumRecipes.has((ItemLike)MalumItems.REPAIR_PYLON.get());
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)ItemTags.PLANKS, (int)4), 0.5f).withRegex(SpiritRepairRegexData.simple("wooden_.+")).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 4).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).withValidItem(Items.BOW).withValidItem(Items.CROSSBOW).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("wooden_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)Items.FLINT, (int)2), 0.5f).withRegex(SpiritRepairRegexData.simple("flint_.+")).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("flint_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS, (int)2), 0.5f).withRegex(SpiritRepairRegexData.simple("stone_.+")).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("stone_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)Tags.Items.INGOTS_COPPER, (int)2), 0.5f).withRegex(SpiritRepairRegexData.simple("copper_.+")).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 6).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("copper_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)Tags.Items.INGOTS_IRON, (int)2), 0.5f).withRegex(SpiritRepairRegexData.simple("iron_.+")).withValidItem((Item)MalumItems.CRUDE_SCYTHE.get()).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("iron_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)Tags.Items.INGOTS_GOLD, (int)2), 0.5f).withRegex(SpiritRepairRegexData.simple("golden_.+")).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("gold_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)Tags.Items.GEMS_DIAMOND, (int)2), 0.5f).withRegex(SpiritRepairRegexData.simple("diamond_.+")).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("diamond_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((TagKey)Tags.Items.INGOTS_NETHERITE, (int)1), 0.5f).withRegex(SpiritRepairRegexData.simple("netherite_.+")).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("netherite_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)Items.PRISMARINE_CRYSTALS, (int)8), 0.5f).withValidItem(Items.TRIDENT).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("trident_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)Items.WIND_CHARGE, (int)8), 0.5f).withValidItem(Items.MACE).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("mace_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)Items.OBSIDIAN, (int)2), 0.75f).withValidItem((Item)MalumItems.TYRVING.get()).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 8).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("tyrving_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.SOUL_STAINED_STEEL_INGOT.get()), (int)2), 0.75f).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_SCYTHE.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_SWORD.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_AXE.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_PICKAXE.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_SHOVEL.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_HOE.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_KNIFE.get()).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("soul_stained_steel_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.SOUL_STAINED_STEEL_PLATING.get()), (int)3), 0.75f).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_HELMET.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_CHESTPLATE.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_LEGGINGS.get()).withValidItem((Item)MalumItems.SOUL_STAINED_STEEL_BOOTS.get()).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("soul_stained_steel_armor_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.SOULWOVEN_SILK.get()), (int)2), 0.75f).withValidItem((Item)MalumItems.SOUL_HUNTER_CLOAK.get()).withValidItem((Item)MalumItems.SOUL_HUNTER_ROBE.get()).withValidItem((Item)MalumItems.SOUL_HUNTER_LEGGINGS.get()).withValidItem((Item)MalumItems.SOUL_HUNTER_BOOTS.get()).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("soul_hunter_armor_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.MALIGNANT_LEAD.get()), (int)8), 0.75f).withValidItem((Item)MalumItems.CATALYST_LOBBER.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 8).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 8).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("catalyst_lobber_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.MNEMONIC_FRAGMENT.get()), (int)8), 0.75f).withValidItem((Item)MalumItems.MNEMONIC_HEX_STAFF.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 8).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 8).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("mnemonic_hex_staff_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.VOID_SALTS.get()), (int)8), 0.75f).withValidItem((Item)MalumItems.EROSION_SCEPTER.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("erosion_scepter_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.MALIGNANT_PEWTER_PLATING.get()), (int)2), 0.75f).withValidItem((Item)MalumItems.MALIGNANT_STRONGHOLD_HELMET.get()).withValidItem((Item)MalumItems.MALIGNANT_STRONGHOLD_CHESTPLATE.get()).withValidItem((Item)MalumItems.MALIGNANT_STRONGHOLD_LEGGINGS.get()).withValidItem((Item)MalumItems.MALIGNANT_STRONGHOLD_BOOTS.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("malignant_stronghold_armor_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.MALIGNANT_PEWTER_INGOT.get()), (int)1), 0.75f).withValidItem((Item)MalumItems.WEIGHT_OF_WORLDS.get()).withValidItem((Item)MalumItems.EDGE_OF_DELIVERANCE.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("malignant_weapon_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.AURIC_EMBERS.get()), (int)8), 0.75f).withValidItem((Item)MalumItems.UNWINDING_CHAOS.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 32).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 32).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 32).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("unwinding_chaos_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.LIVING_FLESH.get()), (int)8), 0.75f).withValidItem((Item)MalumItems.SUNDERING_ANCHOR.get()).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 32).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 32).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 32).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("sundering_anchor_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.ALCHEMICAL_CALX.get()), (int)2), 1.0f).withValidItem((Item)MalumItems.FRACTURED_ALCHEMICAL_IMPETUS.get()).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 4).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("alchemical_impetus_restoration"));
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.WIND_NUCLEUS.get()), (int)4), 1.0f).withValidItem((Item)MalumItems.FRACTURED_ZEPHYR_IMPETUS.get()).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, MalumMod.malumPath("zephyr_impetus_restoration"));
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_IRON_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_COPPER_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_GOLD_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_ALUMINUM_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_NICKEL_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_SILVER_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_TIN_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_ZINC_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_OSMIUM_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_LEAD_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_URANIUM_IMPETUS);
        MalumSpiritRepairRecipes.metalImpetusRestoration(recipeOutput, MalumItems.FRACTURED_COBALT_IMPETUS);
    }

    public static void metalImpetusRestoration(RecipeOutput recipeOutput, Holder<Item> crackedImpetus) {
        ResourceLocation id = crackedImpetus.getKey().location().withSuffix("_restoration");
        Criterion<InventoryChangeTrigger.TriggerInstance> has = MalumRecipes.has((ItemLike)MalumItems.REPAIR_PYLON.get());
        new SpiritRepairRecipeBuilder(SizedIngredient.of((ItemLike)((ItemLike)MalumItems.CTHONIC_GOLD_FRAGMENT.get()), (int)2), 1.0f).withValidItem((Item)crackedImpetus.value()).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 8).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 8).unlockedBy("has_pylon", has).save(recipeOutput, id);
    }
}

