/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe;

import com.mojang.datafixers.util.Pair;
import com.sammy.malum.MalumMod;
import com.sammy.malum.datagen.recipe.builder.UnchainedTransmutationRecipeBuilder;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MalumUnchainedTransmutationRecipes {
    private static final List<Pair<DeferredHolder<Block, Block>, DeferredHolder<Block, Block>>> SOULWOOD_TRANSMUTATIONS = List.of(new Pair(MalumBlocks.RUNEWOOD_TOTEM_BASE, MalumBlocks.SOULWOOD_TOTEM_BASE), new Pair(MalumBlocks.RUNEWOOD_SAPLING, MalumBlocks.SOULWOOD_SAPLING), new Pair(MalumBlocks.RUNEWOOD_LEAVES, MalumBlocks.SOULWOOD_LEAVES), new Pair(MalumBlocks.STRIPPED_RUNEWOOD_LOG, MalumBlocks.STRIPPED_SOULWOOD_LOG), new Pair(MalumBlocks.RUNEWOOD_LOG, MalumBlocks.SOULWOOD_LOG), new Pair(MalumBlocks.STRIPPED_RUNEWOOD, MalumBlocks.STRIPPED_SOULWOOD), new Pair(MalumBlocks.RUNEWOOD, MalumBlocks.SOULWOOD), new Pair(MalumBlocks.REVEALED_RUNEWOOD_LOG, MalumBlocks.REVEALED_SOULWOOD_LOG), new Pair(MalumBlocks.EXPOSED_RUNEWOOD_LOG, MalumBlocks.EXPOSED_SOULWOOD_LOG), new Pair(MalumBlocks.RUNEWOOD_BOARDS, MalumBlocks.SOULWOOD_BOARDS), new Pair(MalumBlocks.RUNEWOOD_BOARDS_SLAB, MalumBlocks.SOULWOOD_BOARDS_SLAB), new Pair(MalumBlocks.RUNEWOOD_BOARDS_STAIRS, MalumBlocks.SOULWOOD_BOARDS_STAIRS), new Pair(MalumBlocks.VERTICAL_RUNEWOOD_BOARDS, MalumBlocks.VERTICAL_SOULWOOD_BOARDS), new Pair(MalumBlocks.VERTICAL_RUNEWOOD_BOARDS_SLAB, MalumBlocks.VERTICAL_SOULWOOD_BOARDS_SLAB), new Pair(MalumBlocks.VERTICAL_RUNEWOOD_BOARDS_STAIRS, MalumBlocks.VERTICAL_SOULWOOD_BOARDS_STAIRS), new Pair(MalumBlocks.RUNEWOOD_PLANKS, MalumBlocks.SOULWOOD_PLANKS), new Pair(MalumBlocks.RUNEWOOD_PLANKS_SLAB, MalumBlocks.SOULWOOD_PLANKS_SLAB), new Pair(MalumBlocks.RUNEWOOD_PLANKS_STAIRS, MalumBlocks.SOULWOOD_PLANKS_STAIRS), new Pair(MalumBlocks.RUSTIC_RUNEWOOD_PLANKS, MalumBlocks.RUSTIC_SOULWOOD_PLANKS), new Pair(MalumBlocks.RUSTIC_RUNEWOOD_PLANKS_SLAB, MalumBlocks.RUSTIC_SOULWOOD_PLANKS_SLAB), new Pair(MalumBlocks.RUSTIC_RUNEWOOD_PLANKS_STAIRS, MalumBlocks.RUSTIC_SOULWOOD_PLANKS_STAIRS), new Pair(MalumBlocks.VERTICAL_RUNEWOOD_PLANKS, MalumBlocks.VERTICAL_SOULWOOD_PLANKS), new Pair(MalumBlocks.VERTICAL_RUNEWOOD_PLANKS_SLAB, MalumBlocks.VERTICAL_SOULWOOD_PLANKS_SLAB), new Pair(MalumBlocks.VERTICAL_RUNEWOOD_PLANKS_STAIRS, MalumBlocks.VERTICAL_SOULWOOD_PLANKS_STAIRS), new Pair(MalumBlocks.VERTICAL_RUSTIC_RUNEWOOD_PLANKS, MalumBlocks.VERTICAL_RUSTIC_SOULWOOD_PLANKS), new Pair(MalumBlocks.VERTICAL_RUSTIC_RUNEWOOD_PLANKS_SLAB, MalumBlocks.VERTICAL_RUSTIC_SOULWOOD_PLANKS_SLAB), new Pair(MalumBlocks.VERTICAL_RUSTIC_RUNEWOOD_PLANKS_STAIRS, MalumBlocks.VERTICAL_RUSTIC_SOULWOOD_PLANKS_STAIRS), new Pair(MalumBlocks.RUNEWOOD_TILES, MalumBlocks.SOULWOOD_TILES), new Pair(MalumBlocks.RUNEWOOD_TILES_SLAB, MalumBlocks.SOULWOOD_TILES_SLAB), new Pair(MalumBlocks.RUNEWOOD_TILES_STAIRS, MalumBlocks.SOULWOOD_TILES_STAIRS), new Pair(MalumBlocks.RUNEWOOD_PANEL, MalumBlocks.SOULWOOD_PANEL), new Pair(MalumBlocks.CUT_RUNEWOOD_PLANKS, MalumBlocks.CUT_SOULWOOD_PLANKS), new Pair(MalumBlocks.RUNEWOOD_BEAM, MalumBlocks.SOULWOOD_BEAM), new Pair(MalumBlocks.RUNEWOOD_DOOR, MalumBlocks.SOULWOOD_DOOR), new Pair(MalumBlocks.SOULWOOD_DOOR, MalumBlocks.BOLTED_SOULWOOD_DOOR), new Pair(MalumBlocks.RUNEWOOD_TRAPDOOR, MalumBlocks.SOULWOOD_TRAPDOOR), new Pair(MalumBlocks.BOLTED_RUNEWOOD_TRAPDOOR, MalumBlocks.BOLTED_SOULWOOD_TRAPDOOR), new Pair(MalumBlocks.RUNEWOOD_BUTTON, MalumBlocks.SOULWOOD_BUTTON), new Pair(MalumBlocks.RUNEWOOD_PRESSURE_PLATE, MalumBlocks.SOULWOOD_PRESSURE_PLATE), new Pair(MalumBlocks.RUNEWOOD_FENCE, MalumBlocks.SOULWOOD_FENCE), new Pair(MalumBlocks.RUNEWOOD_FENCE_GATE, MalumBlocks.SOULWOOD_FENCE_GATE), new Pair(MalumBlocks.RUNEWOOD_BOARDS_WALL, MalumBlocks.SOULWOOD_BOARDS_WALL), new Pair(MalumBlocks.RUNEWOOD_ITEM_STAND, MalumBlocks.SOULWOOD_ITEM_STAND), new Pair(MalumBlocks.RUNEWOOD_ITEM_PEDESTAL, MalumBlocks.SOULWOOD_ITEM_PEDESTAL), new Pair(MalumBlocks.RUNEWOOD_SIGN, MalumBlocks.SOULWOOD_SIGN));

    protected static void buildRecipes(RecipeOutput recipeOutput) {
        for (Pair<DeferredHolder<Block, Block>, DeferredHolder<Block, Block>> transmutation : SOULWOOD_TRANSMUTATIONS) {
            DeferredHolder input = (DeferredHolder)transmutation.getFirst();
            DeferredHolder output = (DeferredHolder)transmutation.getSecond();
            ResourceLocation id = output.getId().withPath(p -> "soulwood/" + p).withSuffix("_soulwood_transmutation");
            new UnchainedTransmutationRecipeBuilder((ItemLike)input.get(), (ItemLike)output.get()).group("soulwood").save(recipeOutput, id);
        }
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "dirt", Blocks.DIRT, Blocks.ROOTED_DIRT, Blocks.GRASS_BLOCK, Blocks.MOSS_BLOCK, (Block)MalumBlocks.BLIGHTED_EARTH.get());
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "stone", Blocks.STONE, Blocks.COBBLESTONE, Blocks.GRAVEL, Blocks.SAND, (Block)MalumBlocks.BLIGHTED_EARTH.get());
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "basalt", Blocks.BASALT, Blocks.MAGMA_BLOCK, Blocks.NETHERRACK, Blocks.SOUL_SAND, (Block)MalumBlocks.BLIGHTED_EARTH.get());
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "mud", Blocks.MUD, Blocks.CLAY, Blocks.PRISMARINE, Blocks.ICE, (Block)MalumBlocks.BLIGHTED_EARTH.get());
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "packed_mud", Blocks.PACKED_MUD, Blocks.DRIPSTONE_BLOCK, Blocks.GRANITE, Blocks.GRAVEL);
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "snow", Blocks.SNOW_BLOCK, Blocks.CALCITE, Blocks.DIORITE, Blocks.GRAVEL);
        MalumUnchainedTransmutationRecipes.createUnchainedRecipeTree(recipeOutput, "polished_basalt", Blocks.DEEPSLATE, Blocks.TUFF, Blocks.ANDESITE, Blocks.GRAVEL);
    }

    public static void createUnchainedRecipeTree(RecipeOutput recipeOutput, String group, Block ... blocks) {
        for (int i = 0; i < blocks.length - 1; ++i) {
            Block input = blocks[i];
            Block output = blocks[i + 1];
            new UnchainedTransmutationRecipeBuilder((ItemLike)input, (ItemLike)output).group(group).save(recipeOutput, MalumMod.malumPath(BuiltInRegistries.BLOCK.getKey((Object)output).getPath() + "_from_" + BuiltInRegistries.BLOCK.getKey((Object)input).getPath()));
        }
    }
}

