/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.infusion;

import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.datagen.recipe.builder.SpiritInfusionRecipeBuilder;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class MaterialSpiritInfusionRecipes {
    public static void buildRecipes(RecipeOutput recipeOutput) {
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.SACRED_SPIRIT, (Item)MalumItems.SACRED_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.WICKED_SPIRIT, (Item)MalumItems.WICKED_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.ARCANE_SPIRIT, (Item)MalumItems.ARCANE_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.ELDRITCH_SPIRIT, (Item)MalumItems.ELDRITCH_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.AERIAL_SPIRIT, (Item)MalumItems.AERIAL_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.AQUEOUS_SPIRIT, (Item)MalumItems.AQUEOUS_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.EARTHEN_SPIRIT, (Item)MalumItems.EARTHEN_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.spiritedGlassRecipe(recipeOutput, MalumSpiritTypes.INFERNAL_SPIRIT, (Item)MalumItems.INFERNAL_SPIRITED_GLASS.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.SACRED_SPIRIT, (Item)MalumItems.SACRED_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.WICKED_SPIRIT, (Item)MalumItems.WICKED_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.ARCANE_SPIRIT, (Item)MalumItems.ARCANE_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.ELDRITCH_SPIRIT, (Item)MalumItems.ELDRITCH_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.AERIAL_SPIRIT, (Item)MalumItems.AERIAL_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.AQUEOUS_SPIRIT, (Item)MalumItems.AQUEOUS_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.EARTHEN_SPIRIT, (Item)MalumItems.EARTHEN_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.varnishedTerracottaRecipe(recipeOutput, MalumSpiritTypes.INFERNAL_SPIRIT, (Item)MalumItems.INFERNAL_VARNISHED_TERRACOTTA.get());
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.SACRED, MalumSpiritTypes.SACRED_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.WICKED, MalumSpiritTypes.WICKED_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.ARCANE, MalumSpiritTypes.ARCANE_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.ELDRITCH, MalumSpiritTypes.ELDRITCH_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.AERIAL, MalumSpiritTypes.AERIAL_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.AQUEOUS, MalumSpiritTypes.AQUEOUS_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.EARTHEN, MalumSpiritTypes.EARTHEN_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.INFERNAL, MalumSpiritTypes.INFERNAL_SPIRIT);
        MaterialSpiritInfusionRecipes.soulwovenBannerRecipe(recipeOutput, SoulwovenBannerPatternDataComponent.COLORFUL_WORLD, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT);
        new SpiritInfusionRecipeBuilder(Items.GUNPOWDER, 1, (ItemLike)MalumItems.HEX_ASH.get(), 1).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Items.ROTTEN_FLESH, 4, (ItemLike)MalumItems.LIVING_FLESH.get(), 2).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 2).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 2).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Items.CLAY_BALL, 4, (ItemLike)MalumItems.ALCHEMICAL_CALX.get(), 4).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 2).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 2).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 2).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)ItemTags.COALS), 4, (ItemLike)MalumItems.ARCANE_CHARCOAL.get(), 4).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 2).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS), 16, (ItemLike)MalumItems.TAINTED_ROCK.get(), 16).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 1).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS), 16, (ItemLike)MalumItems.TWISTED_ROCK.get(), 16).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 1).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Items.GLOWSTONE_DUST, 4, (ItemLike)MalumItems.ETHER.get(), 2).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).addExtraItem((Item)MalumItems.BLAZING_QUARTZ.get(), 1).save(recipeOutput);
        new SpiritInfusionRecipeBuilder((Item)MalumItems.ETHER.get(), 1, (ItemLike)MalumItems.IRIDESCENT_ETHER.get(), 1).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 2).addExtraItem(Items.PRISMARINE_CRYSTALS, 1).addExtraItem((Item)MalumItems.ARCANE_CHARCOAL.get(), 1).carryOverComponentData().save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Items.GOLD_INGOT, 1, (ItemLike)MalumItems.HALLOWED_GOLD_INGOT.get(), 1).addExtraItem(SizedIngredient.of((TagKey)Tags.Items.GEMS_QUARTZ, (int)4)).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 2).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Items.IRON_INGOT, 1, (ItemLike)MalumItems.SOUL_STAINED_STEEL_INGOT.get(), 1).addExtraItem((Item)MalumItems.REFINED_SOULSTONE.get(), 4).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 3).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 1).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 1).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)ItemTags.WOOL), 2, (ItemLike)MalumItems.SOULWOVEN_SILK.get(), 4).addExtraItem(SizedIngredient.of((TagKey)Tags.Items.STRINGS, (int)2)).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 3).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 3).save(recipeOutput);
        new SpiritInfusionRecipeBuilder((Item)MalumItems.ETHER.get(), 1, (ItemLike)MalumItems.PARACAUSAL_FLAME.get(), 1).addExtraItem((Item)MalumItems.HEX_ASH.get(), 8).addExtraItem((Item)MalumItems.WARP_FLUX.get(), 4).addExtraItem(SizedIngredient.of((TagKey)Tags.Items.OBSIDIANS_CRYING, (int)2)).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 8).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 8).save(recipeOutput);
        new SpiritInfusionRecipeBuilder((Item)MalumItems.ALCHEMICAL_CALX.get(), 4, (ItemLike)MalumItems.IMITATION_FLESH.get(), 4).addExtraItem((Item)MalumItems.LIVING_FLESH.get(), 8).addExtraItem(Items.NETHER_WART, 4).addExtraItem((Item)MalumItems.ROTTING_ESSENCE.get(), 2).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).save(recipeOutput);
        new SpiritInfusionRecipeBuilder((Item)MalumItems.ALCHEMICAL_CALX.get(), 4, (ItemLike)MalumItems.IMITATION_HEART.get(), 4).addExtraItem((Item)MalumItems.HEX_ASH.get(), 8).addExtraItem((Item)MalumItems.REFINED_SOULSTONE.get(), 4).addExtraItem((Item)MalumItems.WARP_FLUX.get(), 2).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 16).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 16).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 16).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 4, (ItemLike)MalumItems.ESOTERIC_SPOOL.get(), 4).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 4).addExtraItem((Item)MalumItems.HEX_ASH.get(), 2).save(recipeOutput);
        new SpiritInfusionRecipeBuilder((Item)MalumItems.ANOMALOUS_DESIGN.get(), 1, (ItemLike)MalumItems.COMPLETE_DESIGN.get(), 1).addSpirit(MalumSpiritTypes.SACRED_SPIRIT, 4).addSpirit(MalumSpiritTypes.WICKED_SPIRIT, 4).addSpirit(MalumSpiritTypes.ARCANE_SPIRIT, 4).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 4).addSpirit(MalumSpiritTypes.AERIAL_SPIRIT, 4).addSpirit(MalumSpiritTypes.AQUEOUS_SPIRIT, 4).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 4).addSpirit(MalumSpiritTypes.INFERNAL_SPIRIT, 4).save(recipeOutput);
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 4, (ItemLike)MalumItems.MALIGNANT_PEWTER_INGOT.get(), 1).addExtraItem((Item)MalumItems.MALIGNANT_LEAD.get(), 1).addExtraItem((Item)MalumItems.NULL_SLATE.get(), 8).addExtraItem(Items.NETHERITE_SCRAP, 2).addSpirit(MalumSpiritTypes.EARTHEN_SPIRIT, 16).addSpirit(MalumSpiritTypes.ELDRITCH_SPIRIT, 16).save(recipeOutput);
    }

    public static void spiritedGlassRecipe(RecipeOutput recipeOutput, SpiritHolder<SpiritArcanaType> spirit, Item glass) {
        new SpiritInfusionRecipeBuilder(Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS), 8, (ItemLike)glass, 8).addSpirit(spirit, 2).addExtraItem(Items.IRON_INGOT, 1).save(recipeOutput);
    }

    public static void varnishedTerracottaRecipe(RecipeOutput recipeOutput, SpiritHolder<SpiritArcanaType> spirit, Item terracotta) {
        new SpiritInfusionRecipeBuilder(Items.TERRACOTTA, 8, (ItemLike)terracotta, 8).addSpirit(spirit, 2).addExtraItem((Item)MalumItems.ALCHEMICAL_CALX.get(), 1).save(recipeOutput);
    }

    @SafeVarargs
    public static void soulwovenBannerRecipe(RecipeOutput recipeOutput, SoulwovenBannerPatternDataComponent pattern, SpiritHolder<SpiritArcanaType> ... spirits) {
        SpiritInfusionRecipeBuilder builder = new SpiritInfusionRecipeBuilder((ItemLike)MalumItems.SOULWOVEN_BANNER.get(), pattern.getDefaultStack());
        for (SpiritHolder<SpiritArcanaType> spirit : spirits) {
            builder.addSpirit(spirit, 1);
        }
        builder.save(recipeOutput, pattern.getRecipeId());
    }
}

