/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.worldgen;

import com.sammy.malum.common.worldgen.tree.RunewoodTreeConfiguration;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeFeature;
import com.sammy.malum.common.worldgen.tree.SoulwoodTreeFeature;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.worldgen.MalumFeatures;
import java.util.List;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ConfiguredFeatureDatagen {
    private static final RuleTest STONE_ORE_REPLACEABLES = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
    private static final RuleTest DEEPSLATE_ORE_REPLACEABLES = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
    public static final List<OreConfiguration.TargetBlockState> SOULSTONE_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.SOULSTONE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.DEEPSLATE_SOULSTONE_ORE.get()).defaultBlockState()));
    public static final List<OreConfiguration.TargetBlockState> BRILLIANT_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.BRILLIANT_STONE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.BRILLIANT_DEEPSLATE.get()).defaultBlockState()));
    public static final List<OreConfiguration.TargetBlockState> NATURAL_QUARTZ_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.NATURAL_QUARTZ_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.DEEPSLATE_QUARTZ_ORE.get()).defaultBlockState()));
    public static final List<OreConfiguration.TargetBlockState> CTHONIC_GOLD_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)((Block)MalumBlocks.CTHONIC_GOLD_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES, (BlockState)Blocks.DEEPSLATE_GOLD_ORE.defaultBlockState()));
    public static final List<OreConfiguration.TargetBlockState> BLAZING_QUARTZ_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.BASE_STONE_NETHER), (BlockState)((Block)MalumBlocks.BLAZING_QUARTZ_ORE.get()).defaultBlockState()));

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_SOULSTONE_ORE, ConfiguredFeatureDatagen.addOreConfig(SOULSTONE_TARGET_LIST, 8));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_BRILLIANT_ORE, ConfiguredFeatureDatagen.addOreConfig(BRILLIANT_TARGET_LIST, 4));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_NATURAL_QUARTZ_ORE, ConfiguredFeatureDatagen.addOreConfig(NATURAL_QUARTZ_TARGET_LIST, 5));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_CTHONIC_GOLD_ORE_FEATURE, ConfiguredFeatureDatagen.addOreConfig((Feature<OreConfiguration>)((Feature)MalumFeatures.CTHONIC_GOLD_ORE.get()), CTHONIC_GOLD_TARGET_LIST, 8));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_BLAZING_QUARTZ_ORE, ConfiguredFeatureDatagen.addOreConfig(BLAZING_QUARTZ_TARGET_LIST, 14));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_RUNEWOOD_TREE, ConfiguredFeatureDatagen.addTreeConfig((RunewoodTreeFeature)((Object)MalumFeatures.RUNEWOOD_TREE.get()), new RunewoodTreeConfiguration((Block)MalumBlocks.RUNEWOOD_SAPLING.get(), (Block)MalumBlocks.RUNEWOOD_LOG.get(), (Block)MalumBlocks.EXPOSED_RUNEWOOD_LOG.get(), (Block)MalumBlocks.RUNEWOOD_LEAVES.get(), (Block)MalumBlocks.HANGING_RUNEWOOD_LEAVES.get())));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_AZURE_RUNEWOOD_TREE, ConfiguredFeatureDatagen.addTreeConfig((RunewoodTreeFeature)((Object)MalumFeatures.RUNEWOOD_TREE.get()), new RunewoodTreeConfiguration((Block)MalumBlocks.RUNEWOOD_SAPLING.get(), (Block)MalumBlocks.RUNEWOOD_LOG.get(), (Block)MalumBlocks.EXPOSED_RUNEWOOD_LOG.get(), (Block)MalumBlocks.AZURE_RUNEWOOD_LEAVES.get(), (Block)MalumBlocks.HANGING_AZURE_RUNEWOOD_LEAVES.get())));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_SOULWOOD_TREE, ConfiguredFeatureDatagen.addTreeConfig((SoulwoodTreeFeature)((Object)MalumFeatures.SOULWOOD_TREE.get()), NoneFeatureConfiguration.INSTANCE));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_QUARTZ_GEODE_FEATURE, (Object)new ConfiguredFeature(Feature.GEODE, (FeatureConfiguration)new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)MalumBlocks.NATURAL_QUARTZ_ORE.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)MalumBlocks.NATURAL_QUARTZ_ORE.get())), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.TUFF), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SMOOTH_BASALT), List.of(((Block)MalumBlocks.NATURAL_QUARTZ_CLUSTER.get()).defaultBlockState()), BlockTags.FEATURES_CANNOT_REPLACE, BlockTags.GEODE_INVALID_BLOCKS), new GeodeLayerSettings(1.0, 1.2, 2.2, 2.8), new GeodeCrackSettings(1.0, 4.0, 3), 0.85, 0.2, true, (IntProvider)UniformInt.of((int)3, (int)5), (IntProvider)UniformInt.of((int)2, (int)3), (IntProvider)UniformInt.of((int)0, (int)1), -16, 16, 0.1, 1)));
        context.register(MalumFeatures.ConfiguredFeatures.CONFIGURED_DEEPSLATE_QUARTZ_GEODE_FEATURE, (Object)new ConfiguredFeature(Feature.GEODE, (FeatureConfiguration)new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.AIR), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)MalumBlocks.DEEPSLATE_QUARTZ_ORE.get())), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)MalumBlocks.DEEPSLATE_QUARTZ_ORE.get())), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CALCITE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SMOOTH_BASALT), List.of(((Block)MalumBlocks.NATURAL_QUARTZ_CLUSTER.get()).defaultBlockState()), BlockTags.FEATURES_CANNOT_REPLACE, BlockTags.GEODE_INVALID_BLOCKS), new GeodeLayerSettings(1.0, 1.4, 2.6, 4.2), new GeodeCrackSettings(1.0, 4.0, 3), 0.85, 0.2, true, (IntProvider)UniformInt.of((int)3, (int)5), (IntProvider)UniformInt.of((int)2, (int)3), (IntProvider)UniformInt.of((int)0, (int)1), -16, 16, 0.1, 1)));
    }

    private static <T extends FeatureConfiguration, K extends Feature<T>> ConfiguredFeature<?, ?> addTreeConfig(K feature, T config) {
        return new ConfiguredFeature(feature, config);
    }

    private static ConfiguredFeature<?, ?> addOreConfig(List<OreConfiguration.TargetBlockState> targetList, int veinSize) {
        return new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(targetList, veinSize));
    }

    private static ConfiguredFeature<?, ?> addOreConfig(Feature<OreConfiguration> feature, List<OreConfiguration.TargetBlockState> targetList, int veinSize) {
        return new ConfiguredFeature(feature, (FeatureConfiguration)new OreConfiguration(targetList, veinSize));
    }
}

