/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.registry.common.MalumAttributes;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item getItem();

    @ModifyVariable(method={"addAttributeTooltips"}, at=@At(value="STORE"))
    private ItemAttributeModifiers malum$getTooltip(ItemAttributeModifiers map, @Local(argsOnly=true) Player player) {
        if (player != null && this.getItem() instanceof MalumScytheItem) {
            ItemAttributeModifiers.Builder copied = ItemAttributeModifiers.builder();
            for (ItemAttributeModifiers.Entry entry : map.modifiers()) {
                Holder key = entry.attribute();
                AttributeModifier modifier = entry.modifier();
                double amount = modifier.amount();
                if (modifier.id().equals((Object)Item.BASE_ATTACK_DAMAGE_ID)) {
                    AttributeInstance instance = player.getAttribute(MalumAttributes.SCYTHE_PROFICIENCY);
                    if (instance != null && instance.getValue() > 0.0) {
                        amount += instance.getValue() * 0.5;
                    }
                    copied.add(key, new AttributeModifier(modifier.id(), amount, modifier.operation()), entry.slot());
                    continue;
                }
                copied.add(key, modifier, entry.slot());
            }
            return copied.build();
        }
        return map;
    }
}

