/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.mixin;

import com.sammy.malum.common.effect.ascension.LiftedEffect;
import com.sammy.malum.common.geas.pact.aqueous.SelfCareGeas;
import com.sammy.malum.common.geas.pact.earthen.ProfaneAsceticGeas;
import com.sammy.malum.common.item.curiosities.curios.sets.rotten.CurioVoraciousRing;
import com.sammy.malum.common.item.curiosities.curios.sets.weeping.CurioGruesomeConcentrationRing;
import com.sammy.malum.core.handlers.MalumAttributeEventHandler;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void malum$getDamageAfterArmorAbsorb(DamageSource damageSource, float damageAmount, CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        Optional<Float> optional = MalumAttributeEventHandler.modifyMagicDamageArmorPiercing(livingEntity, damageSource, damageAmount);
        optional.ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void malum$eat(Level level, ItemStack food, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (food.getFoodProperties(livingEntity) != null) {
            CurioVoraciousRing.onEat(level, livingEntity, food);
            CurioGruesomeConcentrationRing.onEat(level, livingEntity, food);
            ProfaneAsceticGeas.onEat(level, livingEntity, food);
            SelfCareGeas.onEat(level, livingEntity, food);
        }
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(DDD)V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;")), index=1)
    private double malum$travel(double y) {
        LivingEntity livingEntity = (LivingEntity)this;
        return LiftedEffect.modifyVelocity(livingEntity, y);
    }
}

