/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.client;

import com.sammy.malum.common.block.curiosities.mana_mote.ManaMoteBlock;
import com.sammy.malum.common.block.ether.EtherBlockEntity;
import com.sammy.malum.common.block.nature.IGradientedLeavesBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.awt.Color;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import team.lodestar.lodestone.systems.easing.Easing;

public class MalumBlockColors {
    public static void setBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((s, l, p, c) -> {
            if (l == null) {
                return -1;
            }
            BlockEntity blockEntity = l.getBlockEntity(p);
            if (blockEntity instanceof EtherBlockEntity) {
                EtherBlockEntity etherBlockEntity = (EtherBlockEntity)blockEntity;
                if (etherBlockEntity.firstColor != null) {
                    return c == 0 ? etherBlockEntity.firstColor.rgb() : -1;
                }
            }
            return -1;
        }, new Block[]{(Block)MalumBlocks.ETHER.get(), (Block)MalumBlocks.IRIDESCENT_ETHER.get()});
        IntegerProperty colorProperty = MalumLeavesBlock.COLOR;
        event.register((s, l, p, c) -> {
            float colorMax = colorProperty.getPossibleValues().size();
            float color = ((Integer)s.getValue((Property)colorProperty)).intValue();
            float pct = colorMax - color / colorMax;
            float value = Easing.SINE_IN_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
            IGradientedLeavesBlock leaves = (IGradientedLeavesBlock)s.getBlock();
            int red = (int)Mth.lerp((float)value, (float)leaves.getMinColor().getRed(), (float)leaves.getMaxColor().getRed());
            int green = (int)Mth.lerp((float)value, (float)leaves.getMinColor().getGreen(), (float)leaves.getMaxColor().getGreen());
            int blue = (int)Mth.lerp((float)value, (float)leaves.getMinColor().getBlue(), (float)leaves.getMaxColor().getBlue());
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)MalumBlocks.RUNEWOOD_LEAVES.get(), (Block)MalumBlocks.HANGING_RUNEWOOD_LEAVES.get(), (Block)MalumBlocks.AZURE_RUNEWOOD_LEAVES.get(), (Block)MalumBlocks.HANGING_AZURE_RUNEWOOD_LEAVES.get()});
        event.register((s, l, p, c) -> {
            BlockState state;
            boolean isPersistent = s.getOptionalValue((Property)MalumLeavesBlock.PERSISTENT).orElse(false);
            int distanceMax = MalumLeavesBlock.DISTANCE.getPossibleValues().size();
            BlockState stateForDistance = s;
            if (s.getOptionalValue((Property)MalumLeavesBlock.DISTANCE).isEmpty() && l != null && p != null && (state = l.getBlockState(p.above())).getBlock() instanceof MalumLeavesBlock) {
                stateForDistance = state;
            }
            float distance = stateForDistance.getOptionalValue((Property)MalumLeavesBlock.DISTANCE).orElse(distanceMax).intValue();
            float colorMax = colorProperty.getPossibleValues().size();
            float color = ((Integer)s.getValue((Property)colorProperty)).intValue();
            float distanceDelta = distance / (float)distanceMax;
            float colorDelta = color / colorMax;
            float value = isPersistent ? colorDelta : Easing.QUAD_OUT.ease(distanceDelta, 0.0f, colorDelta);
            IGradientedLeavesBlock leaves = (IGradientedLeavesBlock)s.getBlock();
            int red = (int)Mth.lerp((float)value, (float)leaves.getMinColor().getRed(), (float)leaves.getMaxColor().getRed());
            int green = (int)Mth.lerp((float)value, (float)leaves.getMinColor().getGreen(), (float)leaves.getMaxColor().getGreen());
            int blue = (int)Mth.lerp((float)value, (float)leaves.getMinColor().getBlue(), (float)leaves.getMaxColor().getBlue());
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)MalumBlocks.SOULWOOD_LEAVES.get(), (Block)MalumBlocks.HANGING_SOULWOOD_LEAVES.get()});
        event.register((s, l, p, c) -> {
            SpiritHolder<SpiritArcanaType> spiritType = SpiritHolder.getSpiritType((String)((Object)s.getValue((Property)ManaMoteBlock.SPIRIT_TYPE)));
            Color color = spiritType.getPrimaryColor();
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)MalumBlocks.SPIRIT_MOTE.get()});
    }
}

