/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.item;

import com.google.common.base.Suppliers;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum MalumItemTiers implements Tier
{
    SOUL_STAINED_STEEL((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1250, 7.5f, 2.5f, 16, (Supplier<Item>)MalumItems.SOUL_STAINED_STEEL_INGOT),
    SPELLWEAVING_TOOLS((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 1500, 5.0f, 3.0f, 24, (Supplier<Item>)MalumItems.CTHONIC_GOLD),
    MALIGNANT_ALLOY((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2500, 8.0f, 4.0f, 24, (Supplier<Item>)MalumItems.MALIGNANT_PEWTER_INGOT),
    HARNESSED_CHAOS((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 2500, 8.0f, 2.5f, 24, (Supplier<Item>)MalumItems.FUSED_CONSCIOUSNESS),
    TYRVING((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1500, 8.0f, 1.0f, 16, (Supplier<Item>)MalumItems.TWISTED_ROCK),
    HEX_STAFF((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1250, 8.0f, 2.5f, 16, (Supplier<Item>)MalumItems.MNEMONIC_FRAGMENT);

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private MalumItemTiers(TagKey<Block> incorrectBlockForDrops, int uses, float speed, float damage, int enchantmentValue, Supplier<Item> repairItem) {
        this.incorrectBlocksForDrops = incorrectBlockForDrops;
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Suppliers.memoize(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)repairItem.get()}));
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

