/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.worldgen;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.worldgen.ore.CthonicGoldOreFeature;
import com.sammy.malum.common.worldgen.ore.LayeredOreFeature;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeFeature;
import com.sammy.malum.common.worldgen.tree.SoulwoodTreeFeature;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MalumFeatures {
    public static final DeferredRegister<Feature<?>> FEATURE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"malum");
    public static final DeferredHolder<Feature<?>, RunewoodTreeFeature> RUNEWOOD_TREE = FEATURE_TYPES.register("runewood_tree", RunewoodTreeFeature::new);
    public static final DeferredHolder<Feature<?>, SoulwoodTreeFeature> SOULWOOD_TREE = FEATURE_TYPES.register("soulwood_tree", SoulwoodTreeFeature::new);
    public static final DeferredHolder<Feature<?>, LayeredOreFeature> CTHONIC_GOLD_ORE = FEATURE_TYPES.register("cthonic_gold_ore", CthonicGoldOreFeature::new);

    public static class PlacedFeatures {
        public static final ResourceKey<PlacedFeature> ORE_SOULSTONE = PlacedFeatures.registerKey("ore_soulstone");
        public static final ResourceKey<PlacedFeature> ORE_BRILLIANT = PlacedFeatures.registerKey("ore_brilliant");
        public static final ResourceKey<PlacedFeature> ORE_NATURAL_QUARTZ = PlacedFeatures.registerKey("ore_natural_quartz");
        public static final ResourceKey<PlacedFeature> ORE_CTHONIC_GOLD = PlacedFeatures.registerKey("cthonic_gold_ore");
        public static final ResourceKey<PlacedFeature> ORE_BLAZING_QUARTZ = PlacedFeatures.registerKey("blazing_quartz_ore");
        public static final ResourceKey<PlacedFeature> RUNEWOOD_TREE = PlacedFeatures.registerKey("runewood_tree");
        public static final ResourceKey<PlacedFeature> RARE_RUNEWOOD_TREE = PlacedFeatures.registerKey("rare_runewood_tree");
        public static final ResourceKey<PlacedFeature> AZURE_RUNEWOOD_TREE = PlacedFeatures.registerKey("azure_runewood_tree");
        public static final ResourceKey<PlacedFeature> RARE_AZURE_RUNEWOOD_TREE = PlacedFeatures.registerKey("rare_azure_runewood_tree");
        public static final ResourceKey<PlacedFeature> QUARTZ_GEODE_FEATURE = PlacedFeatures.registerKey("quartz_geode");
        public static final ResourceKey<PlacedFeature> DEEPSLATE_QUARTZ_GEODE_FEATURE = PlacedFeatures.registerKey("deepslate_quartz_geode");

        public static ResourceKey<PlacedFeature> registerKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)MalumMod.malumPath(name));
        }
    }

    public static class ConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_SOULSTONE_ORE = ConfiguredFeatures.registerKey("soulstone_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_BRILLIANT_ORE = ConfiguredFeatures.registerKey("brilliant_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_NATURAL_QUARTZ_ORE = ConfiguredFeatures.registerKey("natural_quartz_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_BLAZING_QUARTZ_ORE = ConfiguredFeatures.registerKey("blazing_quartz_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CTHONIC_GOLD_ORE_FEATURE = ConfiguredFeatures.registerKey("cthonic_gold_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_RUNEWOOD_TREE = ConfiguredFeatures.registerKey("runewood_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_AZURE_RUNEWOOD_TREE = ConfiguredFeatures.registerKey("azure_runewood_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_SOULWOOD_TREE = ConfiguredFeatures.registerKey("soulwood_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_QUARTZ_GEODE_FEATURE = ConfiguredFeatures.registerKey("quartz_geode");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_DEEPSLATE_QUARTZ_GEODE_FEATURE = ConfiguredFeatures.registerKey("deepslate_quartz_geode");

        public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)MalumMod.malumPath(name));
        }
    }
}

