/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class AvariceParticleEffects {
    public static void avariceItemParticles(Level level, Entity entity) {
        if (level.getGameTime() % 8L == 0L) {
            float width;
            Vec3 center = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            float distance = width = entity.getBbWidth() * 2.0f;
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                ItemStack itemstack = item.getItem();
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel bakedmodel = itemRenderer.getModel(itemstack, entity.level(), null, entity.getId());
                boolean shouldBob = IClientItemExtensions.of((ItemStack)itemstack).shouldBobAsEntity(itemstack);
                float f1 = shouldBob ? Mth.sin((float)((float)item.getAge() / 10.0f + item.bobOffs)) * 0.1f + 0.1f : 0.0f;
                float f2 = bakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
                center = center.add(0.0, (double)(f1 + 0.25f * f2), 0.0);
                distance = Mth.clampedLerp((float)0.0f, (float)width, (float)((float)item.age / 20.0f));
            }
            for (int i = 0; i < 2; ++i) {
                float angle = (float)i + (float)level.getGameTime() % 80.0f / 80.0f;
                int delay = RandomHelper.randomBetween((RandomSource)MalumMod.RANDOM, (int)0, (int)4);
                Vec3 offsetCenter = VecHelper.radialOffset((Vec3)center, (float)distance, (float)angle, (float)2.0f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetCenter, MalumSpiritTypes.INFERNAL_SPIRIT);
                lightSpecs.getBuilder().setLifeDelay(delay).setRandomMotion((double)0.01f).multiplyLifetime(2.5f).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.4f, (float)0.9f, (float)0.0f).build());
                lightSpecs.getBloomBuilder().setLifeDelay(delay).setRandomMotion((double)0.01f).multiplyLifetime(1.5f).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.4f, (float)0.0f).build());
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void avariceFortuneBlockEffect(Level level, MalumNetworkedParticleEffectColorData colorData, Vec3 position) {
        RandomSource random = level.random;
        BlockPos asBlockPos = new BlockPos((int)Math.round(position.x), (int)Math.round(position.y), (int)Math.round(position.z));
        for (int i = 0; i < 4; ++i) {
            float xOffset = (float)Mth.clamp((int)(i % 3), (int)0, (int)1) - 1.0f;
            float zOffset = (float)Mth.clamp((int)((i - 1) % 4), (int)0, (int)1) - 1.0f;
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            SpiritArcanaType spirit = colorData.getSpirit();
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetPosition = new Vec3((double)((float)asBlockPos.getX() + xOffset), (double)((float)(asBlockPos.getY() + j) - 1.0f), (double)((float)asBlockPos.getZ() + zOffset));
                Vec3 toCenter = position.subtract(offsetPosition).normalize();
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spirit);
                Consumer<LodestoneWorldParticle> tickBehavior = p -> {
                    Vec3 speed = p.getParticleSpeed();
                    p.setParticleSpeed(speed.lerp(toCenter, (double)0.2f).normalize().scale(speed.length()).scale((double)0.97f));
                };
                lightSpecs.getBuilder().multiplyLifetime(1.5f).addTickActor(tickBehavior).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(0.75f).addTickActor(tickBehavior).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }
}

