/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.BillboardParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class BlightParticleEffects {
    public static void strangeCrystalForms(Level level, MalumNetworkedParticleEffectColorData color, BlockPos sourcePos, BlockPos targetPos) {
        RandomSource rand = level.getRandom();
        float xOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.5f, (float)0.5f);
        float yOffset = RandomHelper.randomBetween((RandomSource)rand, (float)0.1f, (float)0.2f);
        float zOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.5f, (float)0.5f);
        Vec3 center = targetPos.getCenter().add((double)xOffset, (double)yOffset, (double)zOffset);
        int distance = targetPos.distManhattan((Vec3i)sourcePos);
        int lifetime = 40 + 20 * distance;
        int lifeDelay = 14 * distance;
        for (int i = 0; i < 16; ++i) {
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)center, (float)0.9f, (float)i, (float)16.0f, (float)level.getGameTime(), (float)640.0f);
            SpiritArcanaType spiritType = color.getSpirit();
            for (int j = 0; j < 2; ++j) {
                float acceleration = RandomHelper.randomBetween((RandomSource)rand, (float)0.001f, (float)0.005f);
                Consumer<LodestoneWorldParticle> behavior = p -> {
                    if (p.age < 6) {
                        p.setParticleSpeed(p.getParticleSpeed().add(0.0, (double)acceleration, 0.0));
                    } else {
                        p.setParticleSpeed(p.getParticleSpeed().scale((double)0.92f));
                    }
                };
                float scale = 0.4f + (float)j * 0.2f - (float)distance * 0.05f;
                float alpha = 0.6f - (float)j * 0.1f;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
                lightSpecs.getBuilder().setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)scale, (float)(scale * 0.7f)).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(alpha * 2.0f), (float)alpha, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN).build()).addTickActor(behavior).setLifetime(lifetime).setLifeDelay(lifeDelay + i + j * 6);
                lightSpecs.getBloomBuilder().setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)(scale * 0.6f), (float)(scale * 0.3f)).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(alpha * 0.4f), (float)(alpha * 0.6f), (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN).build()).addTickActor(behavior).setLifetime(lifetime).setLifeDelay(lifeDelay + i + j * 6);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void scarstoneForms(Level level, MalumNetworkedParticleEffectColorData color, BlockPos sourcePos, BlockPos targetPos) {
        RandomSource rand = level.getRandom();
        int distance = targetPos.distManhattan((Vec3i)sourcePos);
        int lifetime = 40 + 20 * distance;
        int lifeDelay = 4 + 6 * distance;
        for (int i = 0; i < 6; ++i) {
            if (!(rand.nextFloat() < 0.75f)) continue;
            float xOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.5f, (float)0.5f);
            float yOffset = RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)0.6f);
            float zOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.5f, (float)0.5f);
            Vec3 particlePosition = targetPos.getCenter().add((double)xOffset, (double)yOffset, (double)zOffset);
            SpiritArcanaType spiritType = color.getSpirit();
            float scale = 0.6f - (float)distance * 0.05f;
            float alpha = 0.4f;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType);
            lightSpecs.getBuilder().setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)scale, (float)(scale * 0.7f)).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(alpha * 2.0f), (float)alpha, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN).build()).setLifetime(lifetime).setLifeDelay(lifeDelay + i * 2).disableNoClip();
            lightSpecs.getBloomBuilder().setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)(scale * 0.6f), (float)(scale * 0.3f)).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(alpha * 0.4f), (float)(alpha * 0.6f), (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN).build()).setLifetime(lifetime).setLifeDelay(lifeDelay + i * 2).disableNoClip();
            lightSpecs.spawnParticles();
        }
    }

    public static void blightSpreads(Level level, BlockPos sourcePos, BlockPos targetPos) {
        RandomSource rand = level.getRandom();
        for (int i = 0; i < 3; ++i) {
            if (!(rand.nextFloat() < 0.85f)) continue;
            Color color = BlightParticleEffects.getBlightColor(rand);
            float xVelocity = RandomHelper.randomBetween((RandomSource)rand, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)rand, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            float xOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.5f, (float)0.5f);
            float yOffset = RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)0.65f);
            float zOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.5f, (float)0.5f);
            Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
            Vec3 particlePosition = targetPos.getCenter().add((double)xOffset, (double)yOffset, (double)zOffset);
            int distance = targetPos.distManhattan((Vec3i)sourcePos);
            int lifetime = 20 + 12 * distance;
            WorldParticleBuilder builder = WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)LodestoneParticleTypes.WISP_PARTICLE.get())).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color).build()).setMotion((double)xVelocity, 0.0, (double)zVelocity).addTickActor(slowDown).setLifetime(lifetime).setNaturalLighting().enableNoClip();
            for (int j = 0; j < 4; ++j) {
                LodestoneWorldParticleRenderType renderType = j / 2 == 0 ? LodestoneWorldParticleRenderType.LUMITRANSPARENT : LodestoneWorldParticleRenderType.ADDITIVE;
                BillboardParticleBehavior behavior = j % 2 == 0 ? DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0)) : BillboardParticleBehavior.INSTANCE;
                float alpha = j / 2 == 0 ? 0.25f : 0.1f;
                float scale = j % 2 == 0 ? 2.0f : 0.8f;
                builder.setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)scale, (float)(scale * 0.7f)).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(alpha * 2.0f), (float)alpha, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN).build()).setRenderType((ParticleRenderType)renderType).setBehavior((LodestoneParticleBehavior)behavior).spawn(level, particlePosition.x, particlePosition.y, particlePosition.z);
            }
        }
    }

    public static void blightPlantGrows(Level level, BlockPos sourcePos, BlockPos targetPos) {
        RandomSource rand = level.getRandom();
        for (int i = 0; i < 3; ++i) {
            if (!(rand.nextFloat() < 0.85f)) continue;
            Color color = BlightParticleEffects.getBlightColor(rand);
            float xOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.3f, (float)0.3f);
            float yOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.6f, (float)-0.4f);
            float zOffset = RandomHelper.randomBetween((RandomSource)rand, (float)-0.3f, (float)0.3f);
            Consumer<LodestoneWorldParticle> movement = p -> {
                Vec3 center = targetPos.getCenter();
                Vec3 distance = p.getParticlePosition().subtract(center.x, center.y + 1.0, center.z);
                Vec3 direction = distance.normalize();
                float delta = Math.max((float)p.getAge() / (float)p.getLifetime(), 0.0f);
                float velocity = Easing.CIRC_IN_OUT.ease((double)delta, (double)0.02f, 0.5 - distance.length() * 0.4);
                Vec3 speed = direction.scale((double)velocity).multiply(1.0, (double)0.7f, 1.0);
                Vec3 lerp = p.getParticleSpeed().lerp(speed, (double)delta);
                p.setParticleSpeed(lerp);
            };
            Vec3 particlePosition = targetPos.getCenter().add((double)xOffset, (double)yOffset, (double)zOffset);
            int distance = targetPos.distManhattan((Vec3i)sourcePos);
            int lifetime = 20 + 12 * distance;
            WorldParticleBuilder builder = WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)LodestoneParticleTypes.WISP_PARTICLE.get())).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)color).build()).addTickActor(movement).setLifetime(lifetime).setNaturalLighting().enableNoClip();
            for (int j = 0; j < 4; ++j) {
                LodestoneWorldParticleRenderType renderType = j / 2 == 0 ? LodestoneWorldParticleRenderType.LUMITRANSPARENT : LodestoneWorldParticleRenderType.ADDITIVE;
                SparkParticleBehavior behavior = j % 2 == 0 ? SparkParticleBehavior.sparkBehavior() : BillboardParticleBehavior.INSTANCE;
                float alpha = j / 2 == 0 ? 0.4f : 0.2f;
                float scale = j % 2 == 0 ? 1.2f : 0.8f;
                builder.setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)scale, (float)(scale * 0.7f)).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(alpha * 2.0f), (float)alpha, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_IN).build()).setRenderType((ParticleRenderType)renderType).setBehavior((LodestoneParticleBehavior)behavior).spawn(level, particlePosition.x, particlePosition.y, particlePosition.z);
            }
        }
    }

    public static Color getBlightColor(RandomSource random) {
        float multiplier = Mth.nextFloat((RandomSource)random, (float)0.4f, (float)1.0f);
        return new Color((int)(31.0f * multiplier), (int)(19.0f * multiplier), (int)(31.0f * multiplier));
    }
}

