/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.common.block.curiosities.runic_workbench.RunicWorkbenchBlockEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.runic_workbench.RunicWorkbenchEffectData;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.behaviors.BillboardParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class RunicWorkbenchParticleEffects {
    public static void craftRuneParticles(Level level, RunicWorkbenchBlockEntity workbench, MalumNetworkedParticleEffectColorData colorData, RunicWorkbenchEffectData extraData) {
        SpiritBasedParticleBuilder builder;
        GenericParticleData scaleData;
        int i;
        long gameTime = level.getGameTime();
        RandomSource rand = level.random;
        Vec3 targetPos = workbench.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritArcanaType spirit = colorData.getSpirit();
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, spirit);
        }
        for (i = 0; i < 6; ++i) {
            int lifeDelay = 2 + i;
            scaleData = GenericParticleData.create((float)0.1f, (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.5f, (float)0.6f) + (float)i * 0.05f), (float)0.5f).setEasing(Easing.SINE_OUT, Easing.SINE_IN).setCoefficient(RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)2.0f)).build();
            builder = SpiritBasedParticleBuilder.createSpirit((LodestoneWorldParticleType)MalumParticles.SQUARE.get()).setSpirit(colorData.getSpirit()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.7f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setScaleData((GenericParticleDataWrapper)scaleData).setLifetime(15).setLifeDelay(lifeDelay).enableNoClip();
            if (i % 2 == 0) {
                builder.act(b -> b.setColorData((ColorParticleDataWrapper)b.getColorData().invert().build()));
            }
            builder.spawn(level, targetPos.x, targetPos.y, targetPos.z).setBehavior((LodestoneParticleBehavior)BillboardParticleBehavior.INSTANCE).setLifetime(8).setLifeDelay((int)((float)lifeDelay * 1.5f)).modifyScaleData(d -> d.multiplyValue(1.25f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyValue(0.6f)).spawn(level, targetPos.x, targetPos.y, targetPos.z);
        }
        for (i = 0; i < 4; ++i) {
            int lifeDelay = 18;
            scaleData = GenericParticleData.create((float)0.2f, (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.3f, (float)0.4f) + (float)i * 0.1f), (float)0.3f).setEasing(Easing.SINE_OUT, Easing.SINE_IN).setCoefficient(RandomHelper.randomBetween((RandomSource)rand, (float)1.5f, (float)2.0f)).build();
            builder = SpiritBasedParticleBuilder.createSpirit((LodestoneWorldParticleType)MalumParticles.SQUARE.get()).setSpirit(colorData.getSpirit()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.0f).setEasing(Easing.EXPO_IN).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setScaleData((GenericParticleDataWrapper)scaleData).setLifetime(15).setLifeDelay(lifeDelay).enableNoClip();
            if (i % 2 == 0) {
                builder.act(b -> b.setColorData((ColorParticleDataWrapper)b.getColorData().invert().build()));
            }
            builder.spawn(level, targetPos.x, targetPos.y, targetPos.z).setBehavior((LodestoneParticleBehavior)BillboardParticleBehavior.INSTANCE).setLifetime(10).modifyScaleData(d -> d.multiplyValue(1.25f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyValue(0.6f)).spawn(level, targetPos.x, targetPos.y, targetPos.z);
        }
        for (i = 0; i < 32; ++i) {
            SpiritArcanaType spirit = colorData.getSpirit();
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)targetPos, (float)0.6f, (float)i, (float)16.0f, (float)gameTime, (float)160.0f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spirit);
            int lifeDelay = i / 2;
            if (i % 2 == 0) {
                lightSpecs.getBuilder().act(b -> b.setColorData((ColorParticleDataWrapper)b.getColorData().invert().build()));
                lightSpecs.getBloomBuilder().act(b -> b.setColorData((ColorParticleDataWrapper)b.getColorData().invert().build()));
            }
            lightSpecs.getBuilder().setMotion(0.0, (double)0.1f, 0.0).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(10).setLifeDelay(4 + lifeDelay);
            lightSpecs.getBloomBuilder().setMotion(0.0, (double)0.1f, 0.0).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(10).setLifeDelay(4 + lifeDelay);
            lightSpecs.spawnParticles();
        }
    }

    public static void craftItemParticles(Level level, RunicWorkbenchBlockEntity workbench, RunicWorkbenchEffectData extraData) {
        SpiritArcanaType spirit;
        int i;
        MalumNetworkedParticleEffectColorData colorData = new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.ARCANE_SPIRIT);
        long gameTime = level.getGameTime();
        Vec3 targetPos = workbench.getItemPos();
        for (i = 0; i < 2; ++i) {
            spirit = colorData.getSpirit();
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos, spirit, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC.get()));
            lightSpecs.getBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(6.0f)).modifyTransparencyData(d -> d.multiplyValue(3.0f)).setLifeDelay(20);
            lightSpecs.getBloomBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(4.0f)).modifyTransparencyData(d -> d.multiplyValue(3.0f)).setLifeDelay(20);
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 32; ++i) {
            spirit = colorData.getSpirit();
            float delta = (float)i / 32.0f;
            int lifeDelay = Mth.floor((float)(delta * 20.0f));
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)targetPos, (float)Mth.lerp((float)delta, (float)0.7f, (float)0.35f), (float)i, (float)16.0f, (float)gameTime, (float)160.0f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spirit);
            if (i % 2 == 0) {
                lightSpecs.getBuilder().act(b -> b.setColorData((ColorParticleDataWrapper)b.getColorData().invert().build()));
                lightSpecs.getBloomBuilder().act(b -> b.setColorData((ColorParticleDataWrapper)b.getColorData().invert().build()));
            }
            lightSpecs.getBuilder().modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifeDelay(lifeDelay);
            lightSpecs.getBloomBuilder().modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(1.2f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.4f)).setLifeDelay(lifeDelay);
            lightSpecs.spawnParticles();
        }
    }
}

