/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.common.block.curiosities.soul_brazier.SoulBrazierBlockEntity;
import com.sammy.malum.common.item.ether.EtherItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;

public class SoulBindingBrazierParticleEffects {
    public static SpiritLike getCentralSpiritType(SoulBrazierBlockEntity brazier) {
        LodestoneBlockEntityInventory spiritInventory = brazier.spiritInventory;
        int spiritCount = spiritInventory.getFilledSlotCount();
        Item currentItem = spiritInventory.getStackInSlot(0).getItem();
        if (spiritCount > 1) {
            float duration = 30.0f * (float)spiritCount;
            float gameTime = (float)brazier.getLevel().getGameTime() % duration / 30.0f;
            currentItem = spiritInventory.getStackInSlot(Mth.floor((float)gameTime)).getItem();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem;
    }

    public static ColorParticleDataBuilder getParticleColor(SoulBrazierBlockEntity brazier) {
        Color end;
        Color start;
        if (brazier.state.equals((Object)SoulBrazierBlockEntity.BrazierState.BINDING)) {
            start = new Color(EtherItem.DEFAULT_FIRST_COLOR.rgb());
            end = new Color(EtherItem.DEFAULT_SECOND_COLOR.rgb());
        } else {
            start = new Color(213, 21, 95);
            end = new Color(18, 120, 199);
        }
        return ColorParticleData.create((Color)start, (Color)end).setEasing(Easing.SINE_IN_OUT);
    }

    public static ColorParticleDataBuilder getBloodColor() {
        return ColorParticleData.create((float)0.6f, (float)0.1f, (float)0.1f);
    }

    public static void beginSoulBindingParticles(SoulBrazierBlockEntity brazier, MalumNetworkedParticleEffectColorData colorData) {
        float scale;
        int i;
        Level level = brazier.getLevel();
        RandomSource random = level.random;
        BlockPos blockPos = brazier.getBlockPos();
        float x = (float)blockPos.getX() + 0.5f;
        float y = (float)blockPos.getY() + 1.1f;
        float z = (float)blockPos.getZ() + 0.5f;
        Vec3 pos = new Vec3((double)x, (double)y, (double)z);
        long gameTime = level.getGameTime();
        ColorParticleDataBuilder color = SoulBindingBrazierParticleEffects.getParticleColor(brazier);
        for (i = 0; i < 4; ++i) {
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)20, (int)25);
            float spin = RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f);
            scale = 5.0f;
            WorldParticleBuilder.create(MalumParticles.RADIAL_DISPLAY).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_OUT, Easing.CUBIC_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale * 0.2f), (float)(scale * RandomHelper.randomBetween((RandomSource)random, (float)0.9f, (float)1.1f))).build()).setColorData((ColorParticleDataWrapper)color.setCoefficient(0.7f).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)spin).build()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(lifeTime).enableNoClip().spawn(level, (double)x, (double)(y - 0.4f), (double)z).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale * 0.2f), (float)(scale * RandomHelper.randomBetween((RandomSource)random, (float)0.9f, (float)1.1f))).build()).setColorData((ColorParticleDataWrapper)color.setCoefficient(1.2f).build()).setMotion(0.0, (double)-0.04f, 0.0).spawn(level, (double)x, (double)(y + 0.4f), (double)z);
        }
        for (i = 0; i < 16; ++i) {
            Vec3 rotatingPos = VecHelper.rotatingRadialOffset((Vec3)pos, (float)0.5f, (float)i, (float)16.0f, (float)gameTime, (float)80.0f);
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)30, (int)40);
            scale = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f);
            float length = RandomHelper.randomBetween((RandomSource)random, (float)1.8f, (float)2.2f);
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)length, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)colorData.getColor()).setMotion(0.0, (double)0.01f, 0.0).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setLengthCenter(1.0f)).setLifetime(lifeTime).setRandomOffset((double)0.1f).spawn(level, rotatingPos.x, rotatingPos.y, rotatingPos.z);
        }
        for (i = 0; i < 3; ++i) {
            float scaleMultiplier = (float)(1.0 + Math.pow(random.nextFloat(), 2.0) * 0.5);
            WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(4.0f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setRandomMotion((double)0.01f, (double)0.01f).setColorData((ColorParticleDataWrapper)colorData.getColor()).setRandomOffset((double)0.2f).setLifetime(25).enableNoClip().spawn(level, (double)x, (double)y, (double)z).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).spawn(level, (double)x, (double)y, (double)z);
        }
        float geasY = (float)((double)blockPos.getY() + SoulBrazierBlockEntity.BRAZIER_GEAS_ICON_OFFSET.y);
        for (int i2 = 0; i2 < 5; ++i2) {
            float scaleMultiplier = (float)(1.0 + Math.pow(random.nextFloat(), 2.0) * 0.5);
            WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.5f, (float)(4.0f * scaleMultiplier), (float)2.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).build()).setRandomMotion((double)0.01f, (double)0.01f).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)colorData.getColor()).setRandomOffset((double)0.2f).setLifetime(25).enableNoClip().setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).spawn(level, (double)x, (double)geasY, (double)z);
        }
    }

    public static void acceptSacrificeParticles(SoulBrazierBlockEntity brazier, LivingEntity entity, MalumNetworkedParticleEffectColorData colorData) {
        int i;
        Level level = brazier.getLevel();
        RandomSource random = level.random;
        BlockPos blockPos = brazier.getBlockPos();
        float x = (float)blockPos.getX() + 0.5f;
        float y = (float)blockPos.getY() + 1.1f;
        float z = (float)blockPos.getZ() + 0.5f;
        float entityX = (float)entity.getX();
        float entityY = (float)(entity.getY() + (double)(entity.getBbHeight() / 2.0f));
        float entityZ = (float)entity.getZ();
        Vec3 pos = new Vec3((double)x, (double)y, (double)z);
        long gameTime = level.getGameTime();
        for (i = 0; i < 16; ++i) {
            Vec3 rotatingPos = VecHelper.rotatingRadialOffset((Vec3)pos, (float)0.6f, (float)i, (float)16.0f, (float)gameTime, (float)80.0f);
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)80, (int)120);
            float scale = RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)0.5f);
            float length = RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.6f);
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setForcedDirection(new Vec3(0.0, 1.0, 0.0)).setLengthCenter(1.0f)).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)length, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)SoulBindingBrazierParticleEffects.getBloodColor().build()).setLifetime(lifeTime).setRandomOffset((double)0.1f).spawn(level, rotatingPos.x, rotatingPos.y, rotatingPos.z);
        }
        for (i = 0; i < 3; ++i) {
            float scaleMultiplier = (float)(1.0 + Math.pow(random.nextFloat(), 2.0) * 0.5);
            WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(4.0f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setRandomMotion((double)0.01f, (double)0.01f).setColorData((ColorParticleDataWrapper)SoulBindingBrazierParticleEffects.getBloodColor().build()).setRandomOffset((double)0.2f).setLifetime(25).enableNoClip().spawn(level, (double)x, (double)y, (double)z).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).spawn(level, (double)x, (double)y, (double)z);
            WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(2.0f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setRandomMotion((double)0.01f, (double)0.01f).setColorData((ColorParticleDataWrapper)SoulBindingBrazierParticleEffects.getBloodColor().build()).setRandomOffset((double)0.2f).setLifetime(25).enableNoClip().spawn(level, (double)entityX, (double)entityY, (double)entityZ).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).spawn(level, (double)entityX, (double)entityY, (double)entityZ);
        }
    }

    public static void finishSoulBindingParticles(SoulBrazierBlockEntity brazier, MalumNetworkedParticleEffectColorData colorData) {
        Level level = brazier.getLevel();
        RandomSource random = level.random;
        BlockPos blockPos = brazier.getBlockPos();
        float x = (float)blockPos.getX() + 0.5f;
        float y = (float)blockPos.getY() + 1.1f;
        float z = (float)blockPos.getZ() + 0.5f;
        Vec3 pos = new Vec3((double)x, (double)y, (double)z);
        long gameTime = level.getGameTime();
        ColorParticleDataBuilder color = SoulBindingBrazierParticleEffects.getParticleColor(brazier);
        for (int j = 0; j < 64; ++j) {
            Vec3 rotatingPos = VecHelper.rotatingRadialOffset((Vec3)pos, (float)2.15f, (float)j, (float)64.0f, (float)gameTime, (float)80.0f);
            Vec3 direction = rotatingPos.subtract(pos).normalize();
            int lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)40, (int)60);
            float scale = RandomHelper.randomBetween((RandomSource)random, (float)1.2f, (float)1.4f);
            float length = RandomHelper.randomBetween((RandomSource)random, (float)4.2f, (float)6.6f);
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.SPARK_PARTICLE).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)length, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)color.build()).setMotion(0.0, (double)0.001f, 0.0).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)direction)).setLifetime(lifeTime).setRandomOffset((double)0.3f).spawn(level, rotatingPos.x, rotatingPos.y - 0.5, rotatingPos.z);
        }
        for (int i = 0; i < 6; ++i) {
            WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)4.0f, (float)6.0f, (float)2.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).build()).setRandomMotion((double)0.01f, (double)0.01f).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)color.build()).setLifetime(20).enableNoClip().spawn(level, (double)x, (double)y, (double)z).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)new Vec3(0.0, 1.0, 0.0))).spawn(level, (double)x, (double)y, (double)z);
        }
    }

    public static void passiveBrazierParticles(SoulBrazierBlockEntity brazier) {
        SpiritLike activeSpiritType = SoulBindingBrazierParticleEffects.getCentralSpiritType(brazier);
        if (activeSpiritType == null) {
            return;
        }
        Level level = brazier.getLevel();
        RandomSource random = level.random;
        Vec3 itemPos = brazier.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = brazier.spiritInventory;
        int spiritsRendered = 0;
        BlockPos blockPos = brazier.getBlockPos();
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            ItemStack item = spiritInventory.getStackInSlot(i);
            Item item2 = item.getItem();
            if (!(item2 instanceof SpiritShardItem)) continue;
            SpiritShardItem shard = (SpiritShardItem)item2;
            Vec3 offset = brazier.getSpiritOffset(spiritsRendered++, 0.0f);
            Vec3 spiritPosition = offset.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, shard).spawnParticles();
            if (!brazier.isActive()) continue;
            Vec3 velocity = itemPos.subtract(spiritPosition).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.04f, (float)0.08f));
            if (random.nextFloat() < 0.9f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, shard);
                sparkParticles.getBuilder().setMotion(velocity).modifyScaleData(d -> d.multiplyValue(1.4f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.nextFloat() < 0.6f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, shard);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.2f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
        if (brazier.isActive()) {
            Vec3 direction;
            float scale;
            int lifeTime;
            SpiritArcanaType spiritType;
            Vec3 spiritSparkPos;
            int i;
            ParticleEffectSpawner lightSpecs;
            float velocity;
            float scale2;
            int lifeTime2;
            ColorParticleData color;
            if (!brazier.sacrificedTargets.isEmpty()) {
                Vec3 bloodPos = itemPos.add(0.0, (double)0.4f, 0.0);
                ColorParticleData color2 = SoulBindingBrazierParticleEffects.getBloodColor().build();
                SpiritLightSpecs.rotatingLightSpecs(level, bloodPos, color2, 0.6f, brazier.sacrificedTargets.size(), b -> b.setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).multiplyLifetime(1.5f));
                SpiritLightSpecs.rotatingLightSpecs(level, bloodPos, color2, 0.6f, brazier.sacrificedTargets.size());
            }
            float x = (float)blockPos.getX() + 0.5f;
            float y = (float)blockPos.getY() + 1.1f;
            float z = (float)blockPos.getZ() + 0.5f;
            Vec3 pos = new Vec3((double)x, (double)y, (double)z);
            long gameTime = level.getGameTime();
            Vec3 rotatingPos = VecHelper.rotatingRadialOffset((Vec3)pos, (float)0.4f, (float)0.0f, (float)1.0f, (float)gameTime, (float)80.0f);
            if (gameTime % 2L == 0L) {
                color = SoulBindingBrazierParticleEffects.getParticleColor(brazier).setCoefficient(1.5f).build();
                lifeTime2 = RandomHelper.randomBetween((RandomSource)random, (int)60, (int)80);
                scale2 = RandomHelper.randomBetween((RandomSource)random, (float)1.2f, (float)1.4f);
                velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.05f);
                lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, color);
                lightSpecs.getBuilder().setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.2f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale2, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).addMotion(0.0, (double)(velocity * 1.2f), 0.0).setLifetime(lifeTime2);
                lightSpecs.spawnParticlesRaw();
            }
            if (gameTime % 2L == 0L) {
                color = SoulBindingBrazierParticleEffects.getParticleColor(brazier).setCoefficient(2.5f).build();
                lifeTime2 = RandomHelper.randomBetween((RandomSource)random, (int)100, (int)120);
                scale2 = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f);
                velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.06f, (float)0.07f);
                lightSpecs = SparkParticleEffects.spiritMotionSparks(level, rotatingPos, color);
                lightSpecs.getBuilder().setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale2, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).addMotion(0.0, (double)(velocity * 1.4f), 0.0).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pos.subtract(rotatingPos).normalize())).setLifetime(lifeTime2).setRandomOffset((double)0.1f);
                lightSpecs.spawnParticlesRaw();
            }
            Vec3 up = new Vec3(0.0, 1.0, 0.0);
            if (gameTime % 12L == 0L) {
                ColorParticleData color3 = SoulBindingBrazierParticleEffects.getParticleColor(brazier).setCoefficient(0.6f).build();
                int lifeTime3 = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
                float scale3 = RandomHelper.randomBetween((RandomSource)random, (float)1.9f, (float)2.2f);
                WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.8f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale3 * 1.5f), (float)0.0f).setEasing(Easing.SINE_IN).build()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)up)).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setMotion(0.0, (double)0.001f, 0.0).setLifetime(lifeTime3).setColorData((ColorParticleDataWrapper)color3).enableNoClip().spawn(level, (double)x, (double)y, (double)z).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale3 * 2.0f), (float)0.0f).setEasing(Easing.SINE_IN).build()).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior()).spawn(level, (double)x, (double)y, (double)z);
            }
            if ((long)brazier.progress % 15L == 0L) {
                ColorParticleDataBuilder color4 = SoulBindingBrazierParticleEffects.getParticleColor(brazier);
                int lifeTime4 = RandomHelper.randomBetween((RandomSource)random, (int)80, (int)100);
                float spin = RandomHelper.randomBetween((RandomSource)random, (float)0.005f, (float)0.01f);
                float scale4 = 4.5f;
                WorldParticleBuilder.create(MalumParticles.RADIAL_DISPLAY).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.5f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale4, (float)(scale4 * RandomHelper.randomBetween((RandomSource)random, (float)0.95f, (float)1.05f))).build()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)up)).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)spin).build()).setColorData((ColorParticleDataWrapper)color4.setCoefficient(0.7f).build()).setLifetime(lifeTime4).enableNoClip().spawn(level, (double)x, (double)(y - 0.4f), (double)z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)1.2f).build()).setLifetime(50).spawn(level, (double)x, (double)y, (double)z).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.5f, (float)0.0f).setCoefficient(0.8f).setEasing(Easing.CUBIC_OUT, Easing.CUBIC_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale4, (float)(scale4 * RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)0.5f))).build()).setColorData((ColorParticleDataWrapper)color4.setCoefficient(1.5f).build()).setMotion(0.0, (double)0.02f, 0.0).setLifetime(40).spawn(level, (double)x, (double)(y - 0.4f), (double)z);
            }
            if (gameTime % 4L == 0L) {
                float distance = 2.15f;
                int amount = brazier.spiritInventory.getFilledSlotCount() * 4;
                MalumNetworkedParticleEffectColorData colorEffectData = MalumNetworkedParticleEffectColorData.fromSpirits(brazier.recipe.spirits);
                Vec3 geasIconPos = SoulBrazierBlockEntity.BRAZIER_GEAS_ICON_OFFSET.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                for (i = 0; i < amount; ++i) {
                    spiritSparkPos = VecHelper.rotatingRadialOffset((Vec3)pos, (float)distance, (float)i, (float)amount, (float)level.getGameTime(), (float)3000.0f);
                    spiritType = colorEffectData.getSpirit();
                    lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)80, (int)100);
                    scale = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f) * Math.min((float)(brazier.progress + 10) / 40.0f, 1.0f);
                    direction = geasIconPos.subtract(spiritSparkPos).normalize();
                    SpiritBasedParticleBuilder.createSpirit(MalumParticles.LIGHT_SPEC).setSpirit(spiritType).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)(scale * 0.2f)).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setRandomOffset(0.1f).setLifetime(lifeTime).enableNoClip().spawn(level, spiritSparkPos.x, spiritSparkPos.y, spiritSparkPos.z).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)direction)).spawn(level, spiritSparkPos.x, spiritSparkPos.y, spiritSparkPos.z);
                    SpiritBasedParticleBuilder.createSpirit(LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setSpirit(spiritType).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale * 8.0f), (float)(scale * 0.2f)).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale * 1.4f), (float)(scale * 0.2f)).setEasing(Easing.SINE_IN_OUT).build()).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setForcedDirection(direction).setLengthCenter(1.0f)).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setRandomOffset(0.1f).setLifetime(40).enableNoClip().spawn(level, spiritSparkPos.x, spiritSparkPos.y, spiritSparkPos.z);
                }
            }
            if (gameTime % 20L == 0L) {
                Vec3 geasIconPos = SoulBrazierBlockEntity.BRAZIER_GEAS_ICON_OFFSET.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                ColorParticleData color5 = activeSpiritType.createColorData().setCoefficient(0.6f).build();
                int lifeTime5 = RandomHelper.randomBetween((RandomSource)random, (int)50, (int)60);
                float scale5 = RandomHelper.randomBetween((RandomSource)random, (float)2.4f, (float)2.8f);
                WorldParticleBuilder.create(MalumParticles.GIANT_GLOWING_STAR).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale5, (float)0.0f).setEasing(Easing.SINE_IN).build()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)up)).setLifetime(lifeTime5).setColorData((ColorParticleDataWrapper)color5).enableNoClip().spawn(level, geasIconPos.x, geasIconPos.y, geasIconPos.z).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)scale5, (float)0.0f).setEasing(Easing.SINE_IN).build()).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setForcedDirection(up)).spawn(level, geasIconPos.x, geasIconPos.y, geasIconPos.z);
            }
            if (gameTime % 4L == 0L) {
                float distance = 1.2f;
                int amount = brazier.spiritInventory.getFilledSlotCount() * 2;
                MalumNetworkedParticleEffectColorData colorEffectData = MalumNetworkedParticleEffectColorData.fromSpirits(brazier.recipe.spirits);
                Vec3 geasIconPos = SoulBrazierBlockEntity.BRAZIER_GEAS_ICON_OFFSET.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                for (i = 0; i < amount; ++i) {
                    spiritSparkPos = VecHelper.rotatingRadialOffset((Vec3)geasIconPos, (float)distance, (float)i, (float)amount, (float)level.getGameTime(), (float)600.0f);
                    spiritType = colorEffectData.getSpirit();
                    lifeTime = RandomHelper.randomBetween((RandomSource)random, (int)60, (int)80);
                    scale = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f) * Math.min((float)(brazier.progress + 10) / 40.0f, 1.0f);
                    direction = geasIconPos.subtract(spiritSparkPos).normalize();
                    SpiritBasedParticleBuilder.createSpirit(MalumParticles.LIGHT_SPEC).setSpirit(spiritType).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)scale, (float)(scale * 0.2f)).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setRandomOffset(0.1f).setLifetime(lifeTime).enableNoClip().spawn(level, spiritSparkPos.x, spiritSparkPos.y, spiritSparkPos.z).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)direction)).spawn(level, spiritSparkPos.x, spiritSparkPos.y, spiritSparkPos.z);
                }
            }
        }
    }
}

