/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlock;
import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlockEntity;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;

public class SoulwovenBannerParticleEffects {
    public static void applyBannerGlow(Level level, MalumNetworkedParticleEffectColorData colorData, SoulwovenBannerBlockEntity banner) {
        Vec3 position = banner.getBlockPos().getCenter();
        Direction direction = ((SoulwovenBannerBlock.BannerType)((Object)banner.getBlockState().getValue(SoulwovenBannerBlock.BANNER_TYPE))).direction;
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        float time = 16.0f;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.005f, (float)0.015f);
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)0.65f, (float)(j + i * 4), (float)32.0f, (float)gameTime, (float)time);
                offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(j * 240)) % time / time) * 0.25 - (double)(0.2f * (float)(j + 1)), 0.0);
                if (direction.getAxis().isHorizontal()) {
                    int stepX = direction.getStepX();
                    int stepZ = direction.getStepZ();
                    offsetPosition = new Vec3(Mth.lerp((double)(0.5f * (float)Mth.abs((int)stepX)), (double)offsetPosition.x, (double)position.x) - (double)(0.35f * (float)stepX), offsetPosition.y, Mth.lerp((double)(0.5f * (float)Mth.abs((int)stepZ)), (double)offsetPosition.z, (double)position.z) - (double)(0.35f * (float)stepZ));
                }
                Vec3 motion = offsetPosition.subtract(position).normalize().scale((double)velocity);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(1.4f).setMotion(motion).setLifeDelay(i + j * 4).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(0.8f).setMotion(motion).setLifeDelay(i + j * 4).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void removeBannerGlow(Level level, MalumNetworkedParticleEffectColorData colorData, SoulwovenBannerBlockEntity banner) {
        Vec3 position = banner.getBlockPos().getCenter();
        Direction direction = ((SoulwovenBannerBlock.BannerType)((Object)banner.getBlockState().getValue(SoulwovenBannerBlock.BANNER_TYPE))).direction;
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        float time = 16.0f;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)0.65f, (float)(j + i * 4), (float)32.0f, (float)gameTime, (float)time);
                offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(j * 240)) % time / time) * 0.25 - (double)1.6f + (double)(0.15f * (float)(j + 1)), 0.0);
                if (direction.getAxis().isHorizontal()) {
                    int stepX = direction.getStepX();
                    int stepZ = direction.getStepZ();
                    offsetPosition = new Vec3(Mth.lerp((double)(0.5f * (float)Mth.abs((int)stepX)), (double)offsetPosition.x, (double)position.x) - (double)(0.35f * (float)stepX), offsetPosition.y, Mth.lerp((double)(0.5f * (float)Mth.abs((int)stepZ)), (double)offsetPosition.z, (double)position.z) - (double)(0.35f * (float)stepZ));
                }
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.05f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(2.0f).setMotion(0.0, (double)(-velocity), 0.0).setLifeDelay(i + j * 2).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.4f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.2f).setMotion(0.0, (double)(-velocity), 0.0).setLifeDelay(i + j * 2).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }
}

