/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.spirit_catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.item.augment.AugmentItem;
import com.sammy.malum.common.item.augment.core.CoreAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.core.systems.artifice.ArtificeInfluenceData;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.artifice.IArtificeAcceptor;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class SpiritCrucibleParticleEffects {
    public static void suspiciousDevicePrimer(NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        GenericParticleData scaleData;
        int i;
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource random = level.random;
        for (i = 0; i < 4; ++i) {
            scaleData = GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)1.2f, (float)0.8f), (float)0.0f).setEasing(Easing.BOUNCE_IN_OUT).setCoefficient(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)1.25f)).build();
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.CIRCLE.get())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.7f, (float)0.3f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)0.8f)).build()).setColorData((ColorParticleDataWrapper)colorData.getColor()).setScaleData((GenericParticleDataWrapper)scaleData).setFriction(0.99f).setRandomOffset(0.25).setLifetime(20).setLifeDelay(i).enableNoClip().repeat((Level)level, positionData.getPosX(), positionData.getPosY(), positionData.getPosZ(), 2);
        }
        for (i = 0; i < 4; ++i) {
            scaleData = GenericParticleData.create((float)0.1f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)0.4f), (float)0.0f).setEasing(Easing.BOUNCE_IN_OUT).setCoefficient(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)1.25f)).build();
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.99f));
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.SHINE.get())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.7f, (float)0.3f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.3f)).build()).setColorData((ColorParticleDataWrapper)colorData.getColor()).setScaleData((GenericParticleDataWrapper)scaleData).addTickActor(behavior).setRandomOffset(0.25).setLifetime(10).setLifeDelay(10 + i).enableNoClip().repeat((Level)level, positionData.getPosX(), positionData.getPosY(), positionData.getPosZ(), 2);
        }
    }

    public static void passiveCrucibleParticles(SpiritCrucibleCoreBlockEntity crucible) {
        BlockPos blockPos;
        Item offset;
        ItemStack item;
        ItemStack item2;
        Item item3;
        SpiritArcanaType activeSpiritType = crucible.getActiveSpiritType();
        Level level = crucible.getLevel();
        RandomSource random = level.random;
        if (level.getGameTime() % 16L == 0L && (item3 = (item2 = crucible.coreAugmentInventory.getStackInSlot(0)).getItem()) instanceof CoreAugmentItem) {
            CoreAugmentItem augmentItem = (CoreAugmentItem)item3;
            BlockPos blockPos2 = crucible.getBlockPos();
            for (SpiritLike augmentSpiritType : augmentItem.spiritTypes) {
                Vec3 offset2 = SpiritCrucibleCoreBlockEntity.CRUCIBLE_CORE_AUGMENT_OFFSET.add((double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f));
                Vec3 particlePosition = blockPos2.getCenter().add(offset2);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyScaleData(d -> d.multiplyValue(1.3f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
                lightSpecs.spawnParticles();
            }
        }
        if (activeSpiritType == null) {
            return;
        }
        Vec3 itemPos = crucible.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = crucible.spiritInventory;
        LodestoneBlockEntityInventory augmentInventory = crucible.augmentInventory;
        SpiritFocusingRecipe recipe = crucible.recipe;
        if (recipe != null) {
            Optional<ArtificeInfluenceData> influenceData = crucible.attributes.getInfluenceData(level);
            influenceData.ifPresent(d -> {
                for (ArtificeModifierSourceInstance modifier : d.modifiers()) {
                    modifier.addParticles(crucible, activeSpiritType);
                }
            });
        }
        if (recipe != null) {
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, itemPos, activeSpiritType, new WorldParticleOptions((ParticleType)MalumParticles.STAR.get()));
            lightSpecs.getBuilder().setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).setSpinOffset((float)level.getGameTime() * 0.05f % 6.28f).build()).modifyScaleData(d -> d.multiplyValue(2.0f)).modifyTransparencyData(d -> d.multiplyValue(0.25f));
            lightSpecs.getBloomBuilder().modifyScaleData(d -> d.multiplyValue(2.0f)).modifyTransparencyData(d -> d.multiplyValue(0.5f));
            lightSpecs.spawnParticles();
        }
        if (recipe != null) {
            int spiritsRendered = 0;
            for (int i = 0; i < spiritInventory.slotCount; ++i) {
                item = spiritInventory.getStackInSlot(i);
                Item item4 = item.getItem();
                if (!(item4 instanceof SpiritShardItem)) continue;
                SpiritShardItem shardItem = (SpiritShardItem)item4;
                offset = crucible.getSpiritItemOffset(spiritsRendered++, 0.0f);
                blockPos = crucible.getBlockPos();
                Vec3 spiritPosition = new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
                Vec3 velocity = itemPos.subtract(spiritPosition).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
                if (random.nextFloat() < 0.85f) {
                    ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, shardItem);
                    sparkParticles.getBuilder().setMotion(velocity).modifyScaleData(d -> d.multiplyValue(1.2f));
                    sparkParticles.getBloomBuilder().setMotion(velocity);
                    sparkParticles.spawnParticles();
                }
                if (!(random.nextFloat() < 0.85f)) continue;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, shardItem);
                lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.6f));
                lightSpecs.getBloomBuilder().setMotion(velocity);
                lightSpecs.spawnParticles();
            }
        }
        if (level.getGameTime() % 4L == 0L) {
            int augmentsRendered = 0;
            for (int i = 0; i < augmentInventory.slotCount; ++i) {
                item = augmentInventory.getStackInSlot(i);
                offset = item.getItem();
                if (!(offset instanceof AugmentItem)) continue;
                AugmentItem augmentItem = (AugmentItem)offset;
                offset = crucible.getAugmentItemOffset(augmentsRendered++, 0.0f);
                blockPos = crucible.getBlockPos();
                Vec3 particlePosition = new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
                for (SpiritLike spiritType : augmentItem.spiritTypes) {
                    if (recipe != null) {
                        Vec3 velocity = itemPos.subtract(particlePosition).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f));
                        if (random.nextFloat() < 0.15f) {
                            ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, spiritType);
                            sparkParticles.getBuilder().multiplyLifetime(2.5f).setMotion(velocity).modifyScaleData(d -> d.multiplyValue(1.2f));
                            sparkParticles.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity);
                            sparkParticles.spawnParticles();
                        }
                        if (random.nextFloat() < 0.15f) {
                            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType);
                            lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(velocity.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.6f));
                            lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity);
                            lightSpecs.spawnParticles();
                        }
                    }
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType);
                    lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyScaleData(d -> d.multiplyValue(1.3f));
                    lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
                    lightSpecs.spawnParticles();
                }
            }
        }
    }

    public static void craftItemParticles(SpiritCrucibleCoreBlockEntity crucible, MalumNetworkedParticleEffectColorData colorData) {
        float zVelocity;
        float yVelocity;
        float xVelocity;
        SpiritArcanaType cyclingSpiritType;
        int i;
        SpiritArcanaType activeSpiritType = crucible.getActiveSpiritType();
        if (activeSpiritType == null) {
            return;
        }
        Level level = crucible.getLevel();
        RandomSource random = level.random;
        BlockPos cruciblePos = crucible.getBlockPos();
        Vec3 crucibleItemPos = cruciblePos.getCenter().add(SpiritCrucibleCoreBlockEntity.CRUCIBLE_ITEM_OFFSET);
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, crucibleItemPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            cyclingSpiritType = colorData.getSpirit();
            xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.5f);
            zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
            if (random.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, crucibleItemPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyScaleData(d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.nextFloat() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, crucibleItemPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravity(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyScaleData(d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyTransparencyData(d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        Vec3 smokePos = crucibleItemPos.subtract(0.0, 0.5, 0.0);
        for (int i2 = 0; i2 < 8; ++i2) {
            cyclingSpiritType = colorData.getSpirit();
            xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.015f, (float)0.035f);
            zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            if (!(random.nextFloat() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, smokePos, cyclingSpiritType, new WorldParticleOptions((ParticleType)MalumParticles.STRANGE_SMOKE.get()));
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(i2).multiplyLifetime(5.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(1.5f)).modifyTransparencyData(d -> d.multiplyValue(0.1f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(i2).multiplyLifetime(5.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(2.5f)).modifyTransparencyData(d -> d.multiplyValue(0.25f));
            lightSpecs.spawnParticles();
        }
    }

    public static void activeSpiritCatalyzerParticles(SpiritCatalyzerCoreBlockEntity catalyzer, IArtificeAcceptor target, SpiritArcanaType spiritType) {
        ItemStack item;
        Item spinData;
        Vec3 velocity;
        Level level = catalyzer.getLevel();
        BlockPos catalyzerPos = catalyzer.getBlockPos();
        Vec3 startPos = SpiritCatalyzerCoreBlockEntity.CATALYZER_ITEM_OFFSET.add((double)catalyzerPos.getX(), (double)catalyzerPos.getY(), (double)catalyzerPos.getZ());
        RandomSource random = level.random;
        Vec3 targetPos = target.getVisualAccelerationPoint();
        if (level.getGameTime() % 2L == 0L) {
            velocity = targetPos.subtract(startPos).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.06f, (float)0.12f));
            Vec3 sparkPos = startPos.add((double)(0.05f - random.nextFloat() * 0.1f), (double)(0.05f - random.nextFloat() * 0.1f), (double)(0.05f - random.nextFloat() * 0.1f));
            ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, sparkPos, spiritType);
            sparkParticles.getBuilder().setMotion(velocity).modifyScaleData(d -> d.multiplyValue(1.5f)).modifyLengthData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.75f)).modifyColorData(c -> c.multiplyCoefficient(0.8f));
            sparkParticles.getBloomBuilder().setMotion(velocity);
            sparkParticles.spawnParticlesRaw();
        }
        if (level.getGameTime() % 10L == 0L) {
            velocity = targetPos.subtract(startPos).normalize().scale((double)0.02f * targetPos.distanceTo(startPos));
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.98f));
            spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.2f)).randomSpinOffset(random).build();
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.HEXAGON.get())).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)velocity.normalize())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.6f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleDataWrapper)spinData).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.15f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)spiritType.createColorData().build()).setLifetime(60).setMotion(velocity).enableNoClip().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE).addTickActor(behavior).spawn(level, startPos.x, startPos.y, startPos.z);
        }
        if (level.getGameTime() % 4L == 0L && (spinData = (item = catalyzer.augmentInventory.getStackInSlot(0)).getItem()) instanceof AugmentItem) {
            AugmentItem augmentItem = (AugmentItem)spinData;
            Vec3 offset = SpiritCatalyzerCoreBlockEntity.CATALYZER_AUGMENT_OFFSET;
            BlockPos blockPos = catalyzer.getBlockPos();
            Vec3 particlePosition = new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
            for (SpiritLike augmentSpiritType : augmentItem.spiritTypes) {
                Vec3 velocity2 = targetPos.subtract(particlePosition).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
                if (random.nextFloat() < 0.15f) {
                    ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, augmentSpiritType);
                    sparkParticles.getBuilder().multiplyLifetime(2.5f).setMotion(velocity2).modifyScaleData(d -> d.multiplyValue(1.2f));
                    sparkParticles.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity2);
                    sparkParticles.spawnParticles();
                }
                if (!(random.nextFloat() < 0.15f)) continue;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(velocity2.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.6f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity2);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void passiveSpiritCatalyzerParticles(SpiritCatalyzerCoreBlockEntity catalyzer) {
        ItemStack item;
        Item item2;
        Level level = catalyzer.getLevel();
        RandomSource random = level.random;
        if (level.getGameTime() % 16L == 0L && (item2 = (item = catalyzer.augmentInventory.getStackInSlot(0)).getItem()) instanceof AugmentItem) {
            AugmentItem augmentItem = (AugmentItem)item2;
            BlockPos blockPos = catalyzer.getBlockPos();
            for (SpiritLike augmentSpiritType : augmentItem.spiritTypes) {
                Vec3 offset = SpiritCatalyzerCoreBlockEntity.CATALYZER_AUGMENT_OFFSET.add((double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f));
                Vec3 particlePosition = new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyScaleData(d -> d.multiplyValue(1.3f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
                lightSpecs.spawnParticles();
            }
        }
    }
}

