/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;

public class TotemParticleEffects {
    public static void activeTotemPoleParticles(TotemPoleBlockEntity totemPole) {
        SpiritArcanaType spiritType = totemPole.getSpirit();
        Level level = totemPole.getLevel();
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        if (gameTime % 12L == 0L) {
            int offset = totemPole.getBlockPos().getY() * 40;
            gameTime += (long)offset;
            float time = 480.0f;
            for (int i = 0; i < 2; ++i) {
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.005f, (float)0.015f);
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)totemPole.getBlockPos().getCenter(), (float)0.9f, (float)i, (float)2.0f, (float)gameTime, (float)480.0f);
                offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(i * 240)) % 480.0f / 480.0f) * 0.25 - 0.25, 0.0);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
                lightSpecs.getBuilder().multiplyLifetime(4.5f).setMotion(0.0, (double)velocity, 0.0).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(3.0f).setMotion(0.0, (double)velocity, 0.0).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void activateTotemPoleParticles(Level level, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectPositionData positionData) {
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        float time = 16.0f;
        Vec3 position = positionData.getAsBlockPos().getCenter();
        for (int i = 0; i < 16; ++i) {
            float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.005f, (float)0.015f);
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)0.85f, (float)i, (float)16.0f, (float)gameTime, (float)time);
            offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(i * 240)) % time / time) * 0.25 - 0.25, 0.0);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
            lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(0.0, (double)velocity, 0.0).setLifeDelay(i).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
            lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(0.0, (double)velocity, 0.0).setLifeDelay(i).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
            lightSpecs.spawnParticles();
        }
    }

    public static void triggerRiteUnweaver(Level level, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectPositionData positionData) {
        long gameTime = level.getGameTime();
        int count = 8;
        Vec3 position = positionData.getAsBlockPos().getBottomCenter();
        float distance = 0.45f;
        ColorParticleDataBuilder voidColorData = ColorParticleData.create((Color)new Color(12, 14, 52), (Color)new Color(6, 8, 12));
        for (int i = 0; i < count; ++i) {
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)distance, (float)i, (float)count, (float)gameTime, (float)320.0f);
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setForcedDirection(SparkParticleBehavior.UP).setLengthCenter(1.0f)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.8f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)0.6f, (float)0.2f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.4f, (float)0.0f).setEasing(Easing.EXPO_IN).build()).setColorData((ColorParticleDataWrapper)voidColorData).setRandomOffset((double)0.1f).setLifetime(15).enableNoClip().repeat(level, offsetPosition, 3);
        }
    }

    public static void triggerRiteAnchor(Level level, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectPositionData positionData) {
        int count = 8;
        Vec3 position = positionData.getAsBlockPos().getBottomCenter().add(0.0, 0.25, 0.0);
        int i = 0;
        while (i < count) {
            int finalI = i++;
            SpiritBasedParticleBuilder.createSpirit(LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setSpirit(colorData.getSpirit()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.15f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.5f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.3f, (float)0.0f).setEasing(Easing.EXPO_IN).build()).setRandomOffset(0.1f).setLifetime(15).enableNoClip().addTickActor(p -> {
                long gameTime = level.getGameTime();
                float distance = 0.6f - 0.4f * ((float)p.getAge() / (float)p.getLifetime());
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)distance, (float)finalI, (float)count, (float)gameTime, (float)40.0f);
                p.setParticlePosition(offsetPosition);
                p.setParticleSpeed(position.subtract(offsetPosition).normalize().scale((double)0.001f));
            }).repeat(level, position, 3);
        }
    }

    public static void triggerRiteAnchorFailure(Level level, MalumNetworkedParticleEffectColorData colorData, NetworkedParticleEffectPositionData positionData) {
        int count = 8;
        Vec3 position = positionData.getAsBlockPos().getBottomCenter().add(0.0, 0.25, 0.0);
        int i = 0;
        while (i < count) {
            int finalI = i++;
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.15f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)0.5f, (float)0.1f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.3f).setEasing(Easing.EXPO_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData((ColorParticleDataWrapper)colorData.getColor()).setRandomOffset((double)0.1f).setLifetime(15).enableNoClip().addTickActor(p -> {
                long gameTime = level.getGameTime();
                float distance = 0.6f - 0.4f * ((float)p.getAge() / (float)p.getLifetime());
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)distance, (float)finalI, (float)count, (float)gameTime, (float)40.0f);
                p.setParticlePosition(offsetPosition);
                p.setParticleSpeed(position.subtract(offsetPosition).normalize().scale((double)0.001f));
            }).repeat(level, position, 3);
        }
    }

    public static void triggerEntityEffect(Level level, MalumNetworkedParticleEffectColorData colorData, Vec3 position) {
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        float time = 16.0f;
        for (int i = 0; i < 8; ++i) {
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)position, (float)0.7f, (float)i, (float)8.0f, (float)gameTime, (float)16.0f);
            offsetPosition = offsetPosition.add(0.0, Math.cos((float)(gameTime + (long)(i * 480)) % 16.0f / 16.0f) * 0.25 - 0.25, 0.0);
            for (int j = 0; j < 3; ++j) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getColor());
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.02f, (float)0.03f);
                Vec3 motion = offsetPosition.subtract(position).normalize().scale((double)velocity);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(motion).setLifeDelay(j * 6).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(motion).setLifeDelay(j * 6).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            SpiritArcanaType spirit = colorData.getSpirit();
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)(position.getY() + j), (double)(position.getZ() + zOffset));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spirit);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion((double)xMotion, 0.0, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockFallEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)(position.getY() + j), (double)(position.getZ() + zOffset));
                float motion = RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.06f);
                Vec3 velocity = position.getCenter().subtract(offsetPosition).add(0.0, -2.0, 0.0).normalize().scale((double)motion);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(velocity).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockGrowEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float yMotion = 0.05f;
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)((float)position.getY() + 0.5f), (double)(position.getZ() + zOffset));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(3.5f).setMotion((double)xMotion, (double)yMotion, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(2.5f).setMotion((double)xMotion, (double)yMotion, (double)zMotion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void triggerBlockInfusionEffect(Level level, MalumNetworkedParticleEffectColorData colorData, BlockPos position) {
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int xOffset = Mth.clamp((int)(i % 3), (int)0, (int)1);
            int zOffset = Mth.clamp((int)((i - 1) % 4), (int)0, (int)1);
            float xMotion = (float)(i % 2) * (i > 1 ? 0.06f : -0.06f);
            float zMotion = (float)((i + 1) % 2) * (i > 1 ? -0.06f : 0.06f);
            for (int j = 0; j < 6; ++j) {
                float yMotion = -0.12f + (float)j * -0.01f;
                float yOffset = 2.5f + (float)(j % 2) + (float)Mth.floor((float)((float)j / 4.0f));
                int lifeDelay = j / 2 * 6;
                Vec3 offsetPosition = new Vec3((double)(position.getX() + xOffset), (double)((float)position.getY() + yOffset), (double)(position.getZ() + zOffset));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, colorData.getSpirit());
                lightSpecs.getBuilder().multiplyLifetime(3.5f).setMotion((double)xMotion, (double)yMotion, (double)zMotion).setLifeDelay(lifeDelay).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(2.5f).setMotion((double)xMotion, (double)yMotion, (double)zMotion).setLifeDelay(lifeDelay).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }
}

