/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectColorData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;

public class MalumNetworkedParticleEffectColorData
extends NetworkedParticleEffectColorData {
    public static final Codec<MalumNetworkedParticleEffectColorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ColorParticleData.CODEC.listOf().fieldOf("colors").forGetter(data -> data.colors), (App)SpiritArcanaType.CODEC.listOf().fieldOf("spirits").forGetter(data -> data.spirits)).apply((Applicative)instance, MalumNetworkedParticleEffectColorData::new));
    public static final StreamCodec<ByteBuf, MalumNetworkedParticleEffectColorData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private final List<SpiritArcanaType> spirits;
    public int colorCycleCounter;

    public static MalumNetworkedParticleEffectColorData fromSpirits(Collection<? extends SpiritLike> spirits) {
        return new MalumNetworkedParticleEffectColorData(Collections.emptyList(), spirits.stream().map(SpiritLike::getSpirit).collect(Collectors.toList()));
    }

    public static MalumNetworkedParticleEffectColorData fromColors(List<? extends ColorParticleDataWrapper> colors) {
        return new MalumNetworkedParticleEffectColorData(colors, Collections.emptyList());
    }

    public static MalumNetworkedParticleEffectColorData fromColor(ColorParticleDataWrapper color) {
        return MalumNetworkedParticleEffectColorData.fromColors(List.of(color));
    }

    public MalumNetworkedParticleEffectColorData(List<? extends ColorParticleDataWrapper> colors, List<? extends SpiritLike> spirits) {
        super(colors);
        this.spirits = spirits.isEmpty() ? Collections.emptyList() : spirits.stream().map(SpiritLike::getSpirit).toList();
    }

    public MalumNetworkedParticleEffectColorData(ColorParticleDataWrapper ... colors) {
        this(List.of(colors), Collections.emptyList());
    }

    public MalumNetworkedParticleEffectColorData(SpiritLike ... spirits) {
        this(Collections.emptyList(), List.of(spirits));
    }

    public boolean isSpiritBased() {
        return this.colors.isEmpty();
    }

    public ColorParticleData getColor() {
        if (!this.spirits.isEmpty()) {
            return this.getSpirit().createColorData().build();
        }
        if (this.colors.size() == 1) {
            return (ColorParticleData)this.colors.getFirst();
        }
        return (ColorParticleData)this.colors.get(this.colorCycleCounter++ % this.colors.size());
    }

    public SpiritArcanaType getSpirit() {
        if (!this.colors.isEmpty()) {
            throw new IllegalArgumentException("Networked Particle Effect expected Spirit Color Data. Raw Color Data was passed instead, which is not supported.");
        }
        if (this.spirits.size() == 1) {
            return this.spirits.getFirst();
        }
        return this.spirits.get(this.colorCycleCounter++ % this.spirits.size());
    }
}

