/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tooltips;

import com.mojang.datafixers.util.Either;
import java.util.List;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.keys.KeyBindings;
import mcjty.lib.tooltips.ClientTooltipIcon;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TooltipRender {
    private static final int STACKS_PER_LINE = 8;
    public static ITooltipSettings lastUsedTooltipItem = null;

    @SubscribeEvent
    public void onMakeTooltip(ItemTooltipEvent event) {
        ITooltipExtras extras;
        List<Pair<ItemStack, Integer>> items;
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof ITooltipExtras && !(items = (extras = (ITooltipExtras)item).getItems(stack)).isEmpty()) {
            List tooltip = event.getToolTip();
            int count = items.size();
            int lines = ((count - 1) / 8 + 1) * 2;
            int width = Math.min(8, count) * 18;
            Object spaces = "";
            while (mc.font.width((String)spaces) < width) {
                spaces = (String)spaces + " ";
            }
            for (int j = 0; j < lines; ++j) {
                tooltip.add(ComponentFactory.literal((String)spaces));
            }
        }
    }

    private static ITooltipSettings getSettings(Item item) {
        if (item instanceof ITooltipSettings) {
            return (ITooltipSettings)item;
        }
        if (item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof ITooltipSettings) {
            return (ITooltipSettings)((BlockItem)item).getBlock();
        }
        return null;
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ManualEntry entry;
        ITooltipSettings settings;
        Item item = event.getItemStack().getItem();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null && (entry = settings.getManualEntry()).manual() != null && KeyBindings.openManual != null && !KeyBindings.openManual.isUnbound() && !SafeClientTools.isSneaking()) {
            Component translationKey = KeyBindings.openManual.getTranslatedKeyMessage();
            event.getToolTip().add(ComponentFactory.literal("<Press ").withStyle(ChatFormatting.YELLOW).append(translationKey).append((Component)ComponentFactory.literal(" for help>").withStyle(ChatFormatting.YELLOW)));
        }
    }

    @SubscribeEvent
    public void onTooltipGatherComponents(RenderTooltipEvent.GatherComponents event) {
        ITooltipSettings settings;
        Item item = event.getItemStack().getItem();
        lastUsedTooltipItem = settings = TooltipRender.getSettings(item);
        if (settings != null) {
            event.setMaxWidth(Math.max(event.getMaxWidth(), settings.getMaxWidth()));
        }
        this.onTooltipAddIcons(event);
    }

    protected void onTooltipAddIcons(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof ITooltipExtras) {
            ITooltipExtras extras = (ITooltipExtras)item;
            List<Pair<ItemStack, Integer>> items = extras.getItems(stack);
            List components = event.getTooltipElements();
            components.add(Either.right((Object)new ClientTooltipIcon(items, 8)));
        }
    }
}

