/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.part;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.PriorityMenu;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.misc.DecompressionService;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class DecompressionModulePart
extends AEBasePart
implements IPriorityHost {
    @PartModels
    private static final IPartModel MODEL = new PartModel(MEGACells.makeId("part/decompression_module"));

    public DecompressionModulePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(10.0);
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!player.getCommandSenderWorld().isClientSide()) {
            MenuOpener.open((MenuType)PriorityMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.closeContainer();
        }
    }

    public int getPriority() {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? ((DecompressionService)grid.getService(DecompressionService.class)).getPatternPriority() : 0;
    }

    public void setPriority(int priority) {
        IGridNode node = this.getMainNode().getNode();
        if (node != null) {
            ((DecompressionService)node.getGrid().getService(DecompressionService.class)).setPatternPriority(priority, node);
            this.getHost().markForSave();
        }
    }

    public ItemStack getMainMenuIcon() {
        return MEGAItems.DECOMPRESSION_MODULE.stack();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }
}

